<?php
/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link          https://cakephp.org CakePHP(tm) Project
 * @since         0.10.0
 * @license       https://opensource.org/licenses/mit-license.php MIT License
 * @var \App\View\AppView $this
 */

$cakeDescription = 'CakePHP: the rapid development php framework'; ?>

<!DOCTYPE html>
<html>
<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>
        <?= $this->fetch('title') ?>
    </title>
    <?= $this->Html->meta('icon', 'https://www.marthatrust.org.uk/favicon.ico') ?>

    <meta name="viewport" content="width=device-width, minimum-scale=1.0, maximum-scale=1.0" />
		<!--[if lt IE 9]>
		<script src="//html5shiv.googlecode.com/svn/trunk/html5.js"></script>
		<![endif]-->

    <link href='https://fonts.googleapis.com/css?family=Expletus+Sans:400,500,600,700,400italic,500italic,600italic,700italic' rel='stylesheet' type='text/css'>

    <?= $this->Html->meta('robots', 'noindex,nofollow') ?>

    <link rel="stylesheet" type="text/css" media="all" href="https://www.marthatrust.org.uk/wp-content/themes/martha2016/style.css" />
    <link rel="stylesheet" type="text/css" media="all" href="https://www.marthatrust.org.uk/wp-content/themes/martha2016/responsive.css" />
    <link rel="stylesheet" type="text/css" media="print" href="https://www.marthatrust.org.uk/wp-content/themes/martha2016/print.css" />

    <?= $this->fetch('meta') ?>
    <?= $this->fetch('css') ?>
    <?= $this->fetch('script') ?>

    <script src='https://www.google.com/recaptcha/api.js'></script>
</head>
<body class="how">
    <div id="outer">
    <div id="wrapper">
    <div id="header"><div id="links"><div id="social"><div id="twitter"><img src="https://www.marthatrust.org.uk/wp-content/themes/martha2016/images/twitter_button.png" /></div><div id="facebook"><img src="https://www.marthatrust.org.uk/wp-content/themes/martha2016/images/facebook_button.png" /></div></div>
    <p><a href="https://www.marthatrust.org.uk/what-we-do/martha-trust-film/">Martha Trust film</a> | <a href="https://www.marthatrust.org.uk/who-we-are/careers/">Careers</a> | <a href="https://www.marthatrust.org.uk/news-and-events/media-centre/">Media centre</a> | <a href="https://www.marthatrust.org.uk/contact-us/">Contact us</a> | <a href="https://www.marthatrust.org.uk/links/">Links</a></p>
    </div>
    <div id="logo"><a href="https://www.marthatrust.org.uk"><img src="https://www.marthatrust.org.uk/wp-content/themes/martha2016/images/main_logo.png" width="155" height="155" border="0" /></a></div>


    <div id="headerRight"><div id="strapline">
    <p>Providing inclusive, lifelong care for people with profound physical and multiple learning disabilities</p>
    </div>

    <div id="donateNow"><a href="https://www.marthatrust.org.uk/donation/donate" class="donateButton"><img src="https://www.marthatrust.org.uk/wp-content/themes/martha2016/images/donate_green.gif" width="144" height="40" /></a></div>
    </div>
    <div id="primaryNav">

        <div class="menu-primary-navigation-container"><ul id="menu-primary-navigation" class="menu"><li id="menu-item-103" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-103"><a href="https://www.marthatrust.org.uk/who-we-are/">Who<span> we are</span></a>
    <ul class="sub-menu">
        <li id="menu-item-104" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-104"><a href="https://www.marthatrust.org.uk/who-we-are/our-mission/">Our mission,</a></li>
        <li id="menu-item-105" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-105"><a href="https://www.marthatrust.org.uk/who-we-are/our-team/">Team,</a></li>
        <li id="menu-item-106" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-106"><a href="https://www.marthatrust.org.uk/who-we-are/our-team/our-trustees/">Trustees,</a></li>
        <li id="menu-item-107" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-107"><a href="https://www.marthatrust.org.uk/who-we-are/careers/">Careers</a></li>
    </ul>
    </li>
    <li id="menu-item-108" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-108"><a href="https://www.marthatrust.org.uk/what-we-do/">What<span> we do</span></a>
    <ul class="sub-menu">
        <li id="menu-item-110" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-110"><a href="https://www.marthatrust.org.uk/what-we-do/">Lifetime care services,</a></li>
        <li id="menu-item-655" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-655"><a href="https://www.marthatrust.org.uk/what-we-do/accessing-our-services/">Accessing our services</a></li>
    </ul>
    </li>
    <li id="menu-item-113" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-113"><a href="https://www.marthatrust.org.uk/how-to-help/">How<span> to help</span></a>
    <ul class="sub-menu">
        <li id="menu-item-114" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-114"><a href="https://www.marthatrust.org.uk/how-to-help/make-a-donation/">Donating,</a></li>
        <li id="menu-item-123" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-123"><a href="https://www.marthatrust.org.uk/how-to-help/fundraise/">Fundraising,</a></li>
        <li id="menu-item-124" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-124"><a href="https://www.marthatrust.org.uk/how-to-help/volunteer/">Volunteering,</a></li>
        <li id="menu-item-115" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-115"><a href="https://www.marthatrust.org.uk/how-to-help/leave-a-legacy/">Legacies</a></li>
    </ul>
    </li>
    <li id="menu-item-118" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-118"><a href="https://www.marthatrust.org.uk/news-and-events/">News<span> &amp; events</span></a>
    <ul class="sub-menu">
        <li id="menu-item-119" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-119"><a href="https://www.marthatrust.org.uk/news-and-events/news/">Latest news,</a></li>
        <li id="menu-item-120" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-120"><a href="https://www.marthatrust.org.uk/news-and-events/events/">Events,</a></li>
        <li id="menu-item-122" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-122"><a href="https://www.marthatrust.org.uk/news-and-events/newsletters/">Newsletters,</a></li>
        <li id="menu-item-121" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-121"><a href="https://www.marthatrust.org.uk/news-and-events/media-centre/">Media</a></li>
    </ul>
    </li>
    </ul></div>
    <div id="search">
        
        <form method="get" id="searchform" action="https://www.marthatrust.org.uk/">
            <label for="s">Site Search</label>
            <input type="text" class="field" name="s" id="s" placeholder="Search..." />
            <input type="submit" class="submit" name="submit" id="searchsubmit" value="Go" />
        </form>
        </div>
    </div>
    </div><!-- /header -->
    <div id="content"><!-- end header.php -->

        <div id="main">

            <?= $this->Flash->render() ?>

            <?= $this->fetch('content') ?>

        </div>
        <div id="right">
            <?= $this->fetch('content_for_right'); ?>
            <div id="contactBox">
                <h3>Get in touch today</h3>
                <p><strong>Martha Trust</strong>,   Homemead
                Lane, Hacklinge, Deal, Kent CT14 0PG</p>
                <p><img src="https://www.marthatrust.org.uk/wp-content/themes/martha2016/images/icon_tel.png" width="19" height="19" />01304 615223 </p>
                <p><img src="https://www.marthatrust.org.uk/wp-content/themes/martha2016/images/icon_email.png" width="21" height="16" /><a href="mailto:info@marthatrust.co.uk">info@marthatrust.org.uk</a></p>
                <p>&nbsp;</p>
            </div>

        </div><!-- /right -->
    </div><!-- /content -->

    <div id="footer">
        <p><a href="https://www.marthatrust.org.uk/">Home</a>  |  <a href="https://www.marthatrust.org.uk/who-we-are/">Who we are</a>  |  <a href="https://www.marthatrust.org.uk/what-we-do/">What we do</a>  |  <a href="https://www.marthatrust.org.uk/how-to-help/">How to help</a>  |  <a href="https://www.marthatrust.org.uk/news-and-events/">News and events</a>  |  <a href="https://www.marthatrust.org.uk/sitemap/">Sitemap</a>  |  <a href="https://www.marthatrust.org.uk/terms-and-conditions/">Terms and conditions</a>  |   <a href="https://www.marthatrust.org.uk/privacy-policy/">Privacy policy</a></p>
        <p>&copy; Martha Trust, 2012 - <?php echo date(
            'Y',
        ); ?>. All rights reserved. <a href="https://www.e-motivemedia.com" target="blank">Website design and development by e-Motive Media Ltd</a>.</p>
    </div><!-- /footer -->

    </div>
    <p class="clear">&nbsp;</p>
    </div>

</body>
</html>
