<?php
if ($decoded['Status'] == 'OK') { ?>
<?php $this->assign('title', 'Thank you for your purchase'); ?>
<?php $this->append(
    'content_for_right',
    '<div class="rightBox"><div class="rightTop"></div><h3>Security info</h3>
        <p>Your payment will be handled safely and securely online by our payment provider SagePay.</p>
    </div>',
); ?>

<h1>Your payment was successful!</h1>
<div id="details">
    <table>
        <tr>
            <td colspan="100%">
                Thank you for your purchase! You will receive an email with your details shortly, which were as follows:
            </td>
        </tr>
        <tr>
            <td>Your name:</td>
            <td>
                <?php echo $order->first_name . ' ' . $order->surname; ?>
            </td>
        </tr>
        <tr>
            <td>Email address:</td>
            <td>
                <?php echo $order->email; ?>
            </td>
        </tr>
        <tr>
            <td>Total amount:</td>
            <td>
                &pound;<?php echo $this->Number->format($decoded['Amount'], ['places' => 2]); ?>
            </td>
        </tr>
        <tr>
            <td>Transaction reference code:</td>
            <td>
                <?php echo $decoded['VendorTxCode']; ?>
            </td>
        </tr>
    </table>

    <p><a href="/" title="Go back to the Martha Trust website">Return to the Martha Trust website >></a></p>
</div>
<?php } else { ?>
<h3>Your payment was unsuccessful</h3>
<p>Your payment was not authorised. Reason: <strong><?php echo $decoded['StatusDetail']; ?></strong></p>
<p>
    If you would like to re-attempt the transaction, please <?php echo $this->Html->link('click here', [
        'action' => 'confirm',
    ]); ?>
</p>
<?php } ?>
