<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Order> $orders
 */
?>

<?php
// echo $this->Html->script('https://www.google.com/recaptcha/api.js', ['inline' => true]);
// $google_captcha_key = Configure::read('googleCaptcha.Google.site-key');
?>

<?php $this->Form->setTemplates([
    'inputContainer' =>
        '<div id="{{div_id}}" class="input {{type}}{{required}} {{extra_div_classes}}">{{before}} {{content}} {{after}}</div>',
    'input' => '{{between}} <input type="{{type}}" name="{{name}}"{{attrs}}/>',
]); ?>

<?php $this->assign('title', 'Online shopping'); ?>

<?php $this->append(
    'content_for_right',
    '<div class="rightBox"><div class="rightTop"></div><h3>Security info</h3>
        <p>Your payment will be handled safely and securely online by our payment provider SagePay.</p>
    </div>',
); ?>

<?php $num = range(0, 15); ?>

<h1>Online shop</h1>

<p>
    When you buy Christmas cards and other items from Martha Trust, you're helping to transform the lives of people with
    profound disabilities. We add just &pound;3.20 for postage and packaging to each order.
</p>
<h2>Your order</h2>

<?php echo $this->Form->create($order); ?>
<?php echo $this->Form->control('id'); ?>

<?php
$i = -1;
foreach ($products as $p) {
    $i++; ?>
<div class="product-container">

    <div class="product-image">
        <a href="<?php echo $this->Html->Url->build(
            '/img/products/' . $p->image,
        ); ?>" data-lightbox="<?php echo $p->name; ?>"
            data-title="<?php echo $p->name; ?> - &pound;<?php echo $p->price; ?>">
            <?php echo $this->Html->image('products/' . $p->image, ['width' => 150]); ?>
        </a>
    </div>
    <div class="product-description">
        <h3><?php echo $p->name; ?>
        </h3>
        <p><strong>&pound;<?php echo $p->price; ?></strong></p>
        <p>
            <?php echo $p->description; ?>
        </p>

        <div>
            <label>Quantity:</label>
            <?php echo $this->Form->control("order_items.{$i}.id"); ?>
            <?php echo $this->Form->control("order_items.{$i}.product_id", [
                'type' => 'hidden',
                'value' => $p->id,
            ]); ?>
            <?php echo $this->Form->control("order_items.{$i}.quantity", [
                'type' => 'select',
                'options' => $num,
                'label' => false,
                'div' => false,
            ]); ?>
        </div>
    </div>
</div>
<?php
}
?>
<p class="clear">&nbsp;</p>
<fieldset>
    <h3>Billing details</h3>
    <?php
    echo $this->Form->control('title_id', ['data-unhide-div' => '#title-other-div', 'data-unhide-text' => 'Other']);
    echo $this->Form->control('title_other', [
        'label' => 'Your title',
        'templateVars' => ['extra_div_classes' => 'hidden', 'div_id' => 'title-other-div'],
    ]);
    echo $this->Form->control('first_name', [
        'label' => 'First name',
        'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
    ]);
    echo $this->Form->control('surname', [
        'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
    ]);
    echo $this->Form->control('address_1', [
        'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
    ]);
    echo $this->Form->control('address_2');
    echo $this->Form->control('city', [
        'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
        'label' => 'Town or city',
    ]);
    echo $this->Form->control('county', [
        'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
    ]);
    echo $this->Form->control('postal_code', [
        'label' => 'Postcode',
        'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
    ]);
    echo $this->Form->control('country_id', [
        'default' => 77,
    ]);
    echo $this->Form->control('telephone', [
        'type' => 'text',
        'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
        'label' => 'Telephone',
    ]);
    echo $this->Form->control('mobile_phone', ['label' => 'Mobile']);
    echo $this->Form->control('email', [
        'label' => 'Email address',
        'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
    ]);
    echo $this->Form->control('email_confirm', [
        'label' => 'Confirm your email address',
        'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
    ]);
    ?>
</fieldset>
<fieldset>
    <h3>Delivery details</h3>
    <div class="input checkbox">
        <label>
            <input type="checkbox" value="1" id="copy-details-check" />
            Same as billing details
        </label>
    </div>
    <?php
    echo $this->Form->control('d_title_id', [
        'label' => 'Title',
        'options' => $titles,
        'data-unhide-div' => '#d-title-other-div',
        'data-unhide-text' => 'Other',
        'data-copy' => '#title-id',
    ]);
    echo $this->Form->control('d_title_other', [
        'label' => 'Your title',
        'templateVars' => ['extra_div_classes' => 'hidden', 'div_id' => 'd-title-other-div'],
        'data-copy' => '#title-other',
    ]);
    echo $this->Form->control('d_first_name', [
        'label' => 'First name',
        'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
        'data-copy' => '#first-name',
    ]);
    echo $this->Form->control('d_surname', [
        'label' => 'Surname',
        'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
        'data-copy' => '#surname',
    ]);
    echo $this->Form->control('d_address_1', [
        'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
        'label' => 'Address 1',
        'data-copy' => '#address-1',
    ]);
    echo $this->Form->control('d_address_2', ['label' => 'Address 2', 'data-copy' => '#address-2']);
    echo $this->Form->control('d_city', [
        'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
        'label' => 'Town or city',
        'data-copy' => '#city',
    ]);
    echo $this->Form->control('d_county', [
        'label' => 'County',
        'templateVars' => ['after' => '<span class="instructions">(required)</span>'],
        'data-copy' => '#county',
    ]);
    echo $this->Form->control('d_postal_code', [
        'label' => 'Postcode',
        'templateVars' => ['after' => '<span class="instructions">(required)</span>', 'label' => 'Postcode'],
        'data-copy' => '#postal-code',
    ]);
    echo $this->Form->control('d_country_id', [
        'default' => 77,
        'label' => 'Country',
        'options' => $countries,
        'data-copy' => '#country-id',
    ]);
    ?>
</fieldset>
<p>Martha Trust would like to keep you updated on our future news, fundraising activities and ways to support us. To opt
    in to receiving information from Martha Trust, please tick how you would prefer to be contacted:</p>
<?php
echo $this->Form->control('optin_email', ['label' => 'Email']);
echo $this->Form->control('optin_telephone', [
    'label' => 'Telephone',
]);
echo $this->Form->control('optin_letter', [
    'label' => 'Letter',
]);
?>
<p>or email <a href="mailto:fundraising@marthatrust.org.uk">fundraising@marthatrust.org.uk</a>.</p>
<p>We do not sell or swap your details with any third parties, but in order to carry out our work we may need to pass
    your details to services companies authorised to act on our behalf.</p>

<fieldset>
    <?php echo $this->Recaptcha->display(); ?>
</fieldset>

<?php echo $this->Form->button(__('Submit')); ?>
<?php echo $this->Form->end(); ?>

<div id="lb-url" data-url="<?php echo $this->Html->Url->build('/'); ?>"></div>
<?php echo $this->Html->css('lightbox/lightbox.min.css', ['block' => 'css']); ?>
<?php echo $this->Html->script(
    ['https://code.jquery.com/jquery-3.7.1.min.js', 'lightbox/lightbox.min.js', 'application.js'],
    ['block' => 'script'],
); ?>
<?php echo $this->Html->css(['forms.css']);
