<?php
if ($decoded['Status'] == 'OK') { ?>
<?php $this->assign('title', 'Thank you for donating to Martha Trust!'); ?>
<?php $this->append(
    'content_for_right',
    '<div class="rightBox"><div class="rightTop"></div><h3>Security info</h3>
        <p>Your donation was handled securely by SagePay.</p>
    </div>',
); ?>

<h1>Your payment was successful!</h1>
<div id="details">
    <table>
        <tr>
            <td colspan="100%">
                Thank you for donating to Martha Trust! You will receive an email with your donation details shortly,
                which were as follows:
            </td>
        </tr>
        <tr>
            <td>Your name:</td>
            <td>
                <?php echo $light->first_name . ' ' . $light->surname; ?>
            </td>
        </tr>
        <tr>
            <td>Email address:</td>
            <td>
                <?php echo $light->email; ?>
            </td>
        </tr>
        <tr>
            <td>Amount donated:</td>
            <td>
                &pound;<?php echo $this->Number->format($decoded['Amount'], ['places' => 2]); ?>
            </td>
        </tr>
        <tr>
            <td>Transaction reference code:</td>
            <td>
                <?php echo $decoded['VendorTxCode']; ?>
            </td>
        </tr>
    </table>

    <p><a href="/" title="Go back to the Martha Trust website">Return to the Martha Trust website >></a></p>
</div>
<?php } else { ?>
<h3>Your payment was unsuccessful</h3>
<p>Your payment was not authorised. Reason: <strong><?php echo $decoded['StatusDetail']; ?></strong></p>
<p>If you would like to re-attempt the transaction, please <?php echo $this->Html->link('click here', [
    'action' => 'confirm',
]); ?></p>
<?php } ?>