<?php
// echo $this->Html->script('https://www.google.com/recaptcha/api.js', ['inline' => true]);
// $google_captcha_key = Configure::read('googleCaptcha.Google.site-key');
?>

<?php $this->Form->setTemplates([
    'inputContainer' =>
        '<div id="{{div_id}}" class="input {{type}}{{required}} {{extra_div_classes}}">{{before}} {{content}} {{after}}</div>',
    'input' => '{{between}} <input type="{{type}}" name="{{name}}"{{attrs}}/>',
]); ?>

<?php $this->assign('title', 'Light up a life with Martha Trust'); ?>

<?php $this->append(
    'content_for_right',
    '
    <div class="rightBox">
        <div class="rightTop"></div><h3>Security info</h3>
        <p>Your donation will be handled safely and securely online by our payment provider SagePay.</p>
    </div>

    <div class="rightBox"><div class="rightTop"></div><h3>Gift Aid</h3>
        <p>If you are a UK taxpayer, please remember to tick the Gift Aid box. This enables us to reclaim tax on your donation, increasing its value to us by almost a third at no extra cost to you. <a href="/how-to-help/gift-aid/" target="blank" title="Find out more about Gift Aid">Find out more about Gift Aid</a></p>
    </div>',
); ?>

<h1>Light up a Life order form</h1>
<p>Thank you for choosing to Light Up A Life with Martha Trust! Please complete the form below.</p>
<div class="donations form">
    <?php echo $this->Form->create($light); ?>
    <fieldset>
        <h2>Your donation</h2>
        <?php
        echo $this->Form->control('id');
        echo $this->Form->control('donation_amount', [
            'label' => 'Donation amount',
            'templateVars' => [
                'between' => '<span class="pound">&pound;</span>',
                'after' => '<span class="instructions">(required)</span>',
            ],
        ]);
        ?>
    </fieldset>
    <fieldset>
        <h2>Your star</h2>
        <?php
        echo $this->Form->control('message');
        echo $this->Form->control('homes', [
            'options' => $homes,
            'type' => 'select',
            'multiple' => 'checkbox',
            'label' =>
                'The Light Up A Life stars will be hung on trees in each of the homes. If you have a preference as to which home you would like your star to be displayed in, please tick the boxes below.',
        ]);
        ?>
    </fieldset>
    <fieldset>
        <h2>Gift Aid</h2>
        <p>Martha Trust will reclaim 25p of tax on every &pound;1 that you have given. Gift Aid is reclaimed by Martha
            Trust from the tax you pay for the current tax year. Your address is needed to identify you as a current UK
            taxpayer.</p>
        <?php
        echo $this->Form->control('gift_aid_for', [
            'options' => $gift_aid_options,
            'type' => 'radio',
            'class' => 'radio',
            'label' => false,
            'templateVars' => [
                'before' => '<p>Please apply Gift Aid to:</p>',
                'div_id' => 'gift-aid-div',
                'extra_div_classes' => 'full-labels',
            ],
        ]);
        echo $this->Form->control('gift_aid_understood', [
            'label' =>
                'I confirm I am a UK taxpayer and understand that if I pay less Income Tax and/or Capital Gains Tax than the amount of Gift Aid claimed on all donations in that tax year it is my responsibility to pay the difference.',
        ]);
        ?>

        <p>Please notify Martha Trust if you: want to cancel this declaration; change your name or home address; no
            longer pay sufficient tax on your income and/or capital gains tax.</p>
    </fieldset>
    <fieldset>
        <h2>Your details</h2>
        <?php
        echo $this->Form->control('title_id', [
            'data-unhide-div' => '#title-other-div',
            'data-unhide-text' => 'Other',
        ]);
        echo $this->Form->control('title_other', [
            'label' => 'Your title',
            'templateVars' => [
                'extra_div_classes' => 'hidden',
                'div_id' => 'title-other-div',
            ],
        ]);
        echo $this->Form->control('first_name', [
            'label' => 'First name',
            'templateVars' => [
                'after' => '<span class="instructions">(required)</span>',
            ],
        ]);
        echo $this->Form->control('surname', [
            'templateVars' => [
                'after' => '<span class="instructions">(required)</span>',
            ],
        ]);

        echo $this->Form->control('address_1', [
            'templateVars' => [
                'after' => '<span class="instructions">(required)</span>',
            ],
        ]);
        echo $this->Form->control('address_2');
        echo $this->Form->control('city', [
            'templateVars' => [
                'after' => '<span class="instructions">(required)</span>',
            ],
            'label' => 'Town or city',
        ]);
        echo $this->Form->control('county', [
            'templateVars' => [
                'after' => '<span class="instructions">(required)</span>',
            ],
        ]);
        echo $this->Form->control('postal_code', [
            'label' => 'Postcode',
            'templateVars' => [
                'after' => '<span class="instructions">(required)</span>',
            ],
        ]);
        echo $this->Form->control('country_id', [
            'default' => 77,
            'data-unhide-text' => 'United States',
            'data-unhide-div' => '#state-code-div',
        ]);
        echo $this->Form->control('state_code', [
            'templateVars' => [
                'extra_div_classes' => 'hidden',
                'div_id' => 'state-code-div',
            ],
        ]);
        ?>
    </fieldset>
    <fieldset>
        <h2>Contact details</h2>
        <?php
        echo $this->Form->control('telephone', [
            'type' => 'text',
            'templateVars' => [
                'after' => '<span class="instructions">(required)</span>',
            ],
        ]);
        echo $this->Form->control('mobile_phone');
        echo $this->Form->control('email', [
            'label' => 'Email address',
            'templateVars' => [
                'after' => '<span class="instructions">(required)</span>',
            ],
        ]);
        echo $this->Form->control('email_confirm', [
            'label' => 'Confirm your email address',
            'templateVars' => [
                'after' => ' <span class="instructions">(required)</span>',
            ],
        ]);
        ?>
        <p>Martha Trust would like to keep you updated on our future news, fundraising activities and ways to support
            us. To opt in to receiving information from Martha Trust, please tick how you would prefer to be contacted::
        </p>
        <?php
        echo $this->Form->control('optin_email', ['label' => 'Email']);
        echo $this->Form->control('optin_telephone', ['label' => 'Telephone']);
        echo $this->Form->control('optin_letter', ['label' => 'Letter']);
        ?>
        <p><a href="mailto:fundraising@marthatrust.org.uk">fundraising@marthatrust.org.uk</a>.</p>
        <p>We do not sell or swap your details with any third parties, but in order to carry out our work we may need to
            pass your details to services companies authorised to act on our behalf.</p>
    </fieldset>
    <fieldset>
        <?php echo $this->Recaptcha->display(); ?>
    </fieldset>
    <?php echo $this->Form->button(__('Submit')); ?>
    <?php echo $this->Form->end(); ?>
</div>

<?php echo $this->Html->script(['https://code.jquery.com/jquery-3.7.1.min.js', 'application.js']); ?>
<?php echo $this->Html->css(['forms.css']);
