<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Donation $donation
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Donation'), ['action' => 'edit', $donation->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Donation'), ['action' => 'delete', $donation->id], ['confirm' => __('Are you sure you want to delete # {0}?', $donation->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Donations'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Donation'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="donations view content">
            <h3><?= h($donation->title_other) ?></h3>
            <table>
                <tr>
                    <th><?= __('Gift Aid For') ?></th>
                    <td><?= h($donation->gift_aid_for) ?></td>
                </tr>
                <tr>
                    <th><?= __('Title') ?></th>
                    <td><?= $donation->hasValue('title') ? $this->Html->link($donation->title->name, ['controller' => 'Titles', 'action' => 'view', $donation->title->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Title Other') ?></th>
                    <td><?= h($donation->title_other) ?></td>
                </tr>
                <tr>
                    <th><?= __('First Name') ?></th>
                    <td><?= h($donation->first_name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Surname') ?></th>
                    <td><?= h($donation->surname) ?></td>
                </tr>
                <tr>
                    <th><?= __('Address 1') ?></th>
                    <td><?= h($donation->address_1) ?></td>
                </tr>
                <tr>
                    <th><?= __('Address 2') ?></th>
                    <td><?= h($donation->address_2) ?></td>
                </tr>
                <tr>
                    <th><?= __('City') ?></th>
                    <td><?= h($donation->city) ?></td>
                </tr>
                <tr>
                    <th><?= __('County') ?></th>
                    <td><?= h($donation->county) ?></td>
                </tr>
                <tr>
                    <th><?= __('Postal Code') ?></th>
                    <td><?= h($donation->postal_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Country') ?></th>
                    <td><?= $donation->hasValue('country') ? $this->Html->link($donation->country->name, ['controller' => 'Countries', 'action' => 'view', $donation->country->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('State Code') ?></th>
                    <td><?= h($donation->state_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Email') ?></th>
                    <td><?= h($donation->email) ?></td>
                </tr>
                <tr>
                    <th><?= __('Email Confirm') ?></th>
                    <td><?= h($donation->email_confirm) ?></td>
                </tr>
                <tr>
                    <th><?= __('Telephone') ?></th>
                    <td><?= h($donation->telephone) ?></td>
                </tr>
                <tr>
                    <th><?= __('Mobile Phone') ?></th>
                    <td><?= h($donation->mobile_phone) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Status') ?></th>
                    <td><?= h($donation->tx_status) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Status Detail') ?></th>
                    <td><?= h($donation->tx_status_detail) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Code') ?></th>
                    <td><?= h($donation->tx_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Sagepay Id') ?></th>
                    <td><?= h($donation->tx_sagepay_id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Cardtype') ?></th>
                    <td><?= h($donation->tx_cardtype) ?></td>
                </tr>
                <tr>
                    <th><?= __('Decline Code') ?></th>
                    <td><?= h($donation->decline_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Expiry Date') ?></th>
                    <td><?= h($donation->expiry_date) ?></td>
                </tr>
                <tr>
                    <th><?= __('Bank Auth Code') ?></th>
                    <td><?= h($donation->bank_auth_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Organisation') ?></th>
                    <td><?= h($donation->organisation) ?></td>
                </tr>
                <tr>
                    <th><?= __('Message') ?></th>
                    <td><?= h($donation->message) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($donation->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Donation Amount') ?></th>
                    <td><?= $this->Number->format($donation->donation_amount) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Card Lastdigits') ?></th>
                    <td><?= $this->Number->format($donation->tx_card_lastdigits) ?></td>
                </tr>
                <tr>
                    <th><?= __('Created') ?></th>
                    <td><?= h($donation->created) ?></td>
                </tr>
                <tr>
                    <th><?= __('Modified') ?></th>
                    <td><?= h($donation->modified) ?></td>
                </tr>
                <tr>
                    <th><?= __('Gift Aid Understood') ?></th>
                    <td><?= $donation->gift_aid_understood ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('No Email') ?></th>
                    <td><?= $donation->no_email ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('No Telephone') ?></th>
                    <td><?= $donation->no_telephone ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('No Letter') ?></th>
                    <td><?= $donation->no_letter ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Optin Email') ?></th>
                    <td><?= $donation->optin_email ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Optin Telephone') ?></th>
                    <td><?= $donation->optin_telephone ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Optin Letter') ?></th>
                    <td><?= $donation->optin_letter ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Is Mail Sent') ?></th>
                    <td><?= $donation->is_mail_sent ? __('Yes') : __('No'); ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
