<?php use Cake\Core\Configure; ?>

<h1>Confirm your donation</h1>

<?php $this->assign('title', 'Confirm the details of your donation to Martha Trust'); ?>
<?php $this->append(
    'content_for_right',
    '<div class="rightBox"><div class="rightTop"></div><h3>Security information</h3>
        <p>Your donation will be handled safely and securely online by our payment provider SagePay.</p>
        </div>

        <div class="rightBox"><div class="rightTop"></div><h3>Gift Aid</h3>
        <p>If you are a UK taxpayer, please remember to tick the Gift Aid box. This enables us to reclaim tax on your donation, increasing its value to us by almost a third at no extra cost to you. <a href="/how-to-help/gift-aid/" target="blank" title="Find out more about Gift Aid">Find out more about Gift Aid</a></p>
    </div>',
); ?>

<p>
    Please check the details below to be sure they are correct. If you would like to change anything, you can
    <?php echo $this->Html->link('go back and make changes', ['action' => 'donate']); ?>.
</p>

<table>
    <tr>
        <td colspan="100%"><strong>Your donation</strong></td>
    </tr>
    <tr>
        <td>Donation amount</td>
        <td>&pound;<?php echo $donation->donation_amount; ?></td>
    </tr>
    <tr>
        <td>Gift Aid</td>
        <td><?php echo $donation->gift_aid_for; ?></td>
    </tr>
    <tr>
        <td colspan="100%"><strong>Your details</strong></td>
    <tr>
        <td>Title</td>
        <td><?php echo $donation->title->name; ?></td>
    </tr>
    <?php if ($donation->title->name === 'Other') { ?>
    <tr>
        <td>Title (if Other)</td>
        <td><?php echo $donation->title_other; ?></td>
    </tr>
    <?php } ?>

    <tr>
        <td>First name</td>
        <td><?php echo $donation->first_name; ?></td>
    </tr>
    <tr>
        <td>Surname</td>
        <td><?php echo $donation->surname; ?></td>
    </tr>
    <tr>
        <td>Organisation</td>
        <td><?php echo $donation->organisation; ?></td>
    </tr>
    <tr>
        <td>Address 1</td>
        <td><?php echo $donation->address_1; ?></td>
    </tr>
    <tr>
        <td>Address 2</td>
        <td><?php echo $donation->address_2; ?></td>
    </tr>
    <tr>
        <td>City</td>
        <td><?php echo $donation->city; ?></td>
    </tr>
    <tr>
        <td>Postcode</td>
        <td><?php echo $donation->postal_code; ?></td>
    </tr>
    <tr>
        <td>Country</td>
        <td><?php echo $donation->country->name; ?></td>
    </tr>
    <?php if ($donation->country->name === 'United States') { ?>
    <tr>
        <td>State code</td>
        <td><?php echo $donation->state_code; ?></td>
    </tr>
    <?php } ?>
    <tr>
        <td colspan="100%"><strong>Contact details</strong></td>
    </tr>
    <tr>
        <td>Telephone</td>
        <td><?php echo $donation->telephone; ?></td>
    </tr>
    <tr>
        <td>Mobile phone</td>
        <td><?php echo $donation->mobile_phone; ?></td>
    </tr>
    <tr>
        <td>Email address</td>
        <td><?php echo $donation->email; ?></td>
    </tr>
    <tr>
        <td>Contact by email</td>
        <td><?php echo $donation->optin_email ? 'Yes' : 'No'; ?></td>
    </tr>
    <tr>
        <td>Contact by telephone</td>
        <td><?php echo $donation->optin_telephone ? 'Yes' : 'No'; ?></td>
    </tr>
    <tr>
        <td>Contact by letter</td>
        <td><?php echo $donation->optin_letter ? 'Yes' : 'No'; ?></td>
    </tr>

    <tr>
        <td>Message</td>
        <td><?php echo $donation->message; ?></td>
    </tr>
</table>

<p>If you're happy with your donation details, please click Proceed to continue with your donation: </p>
<p>
<form action="<?php echo $sagepay_url; ?>" method="POST" id="SagePayForm" name="SagePayForm">
    <input type="hidden" name="VPSProtocol" value="3.00">
    <input type="hidden" name="TxType" value="PAYMENT">
    <input type="hidden" name="Vendor" value="<?php echo Configure::read('Forms.SagePay.vendor_name'); ?>">
    <input type="hidden" name="Crypt" value="<?php echo $crypted; ?>">
    <input type="submit" value="Proceed to payment" />
</form>
</p>