<?php
/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link          https://cakephp.org CakePHP(tm) Project
 * @since         0.10.0
 * @license       https://opensource.org/licenses/mit-license.php MIT License
 * @var \App\View\AppView $this
 */

$cakeDescription = 'CakePHP: the rapid development php framework'; ?>
<!DOCTYPE html>
<html>

<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>
        Martha Trust transactional form administration
    </title>
    <?= $this->Html->meta('icon') ?>

    <?= $this->Html->css(['normalize.min', 'milligram.min', 'fonts', 'cake']) ?>

    <?= $this->fetch('meta') ?>
    <?= $this->fetch('css') ?>
    <?= $this->fetch('script') ?>
</head>

<body>
    <nav class="top-nav">
        <div class="top-nav-title">
            <a href="<?= $this->Url->build('/') ?>"><span>Martha Trust</span> transactional form administration</a>
        </div>
    </nav>
    <main class="main">
        <div class="row">
            <div class="main-nav column column-10">
                <h4>Main Menu</h4>
                <h6>Donations</h6>
                <?= $this->Html->link(__('Donations'), ['action' => 'index', 'controller' => 'donations'], ['class' => 'side-nav-item']) ?>
                <?= $this->Html->link(__('Light Up Life orders'), ['action' => 'index', 'controller' => 'lights'], ['class' => 'side-nav-item']) ?>
                <div class="separator"></div>
                <h6>Generic events registrations</h6>
                <?= $this->Html->link(__('Event signups'), ['action' => 'index', 'controller' => 'registrations'], ['class' => 'side-nav-item']) ?>
                <?= $this->Html->link(__('Events'), ['action' => 'index', 'controller' => 'events'], ['class' => 'side-nav-item']) ?>
                <div class="separator"></div>
                <h6>Specific event registrations</h6>
                <?= $this->Html->link(__('Golf Day signups'), ['action' => 'index', 'controller' => 'golfs'], ['class' => 'side-nav-item']) ?>
                <?= $this->Html->link(__('Golf Day types'), ['action' => 'index', 'controller' => 'golf_types'], ['class' => 'side-nav-item']) ?>
                <?= $this->Html->link(__('Golf Day sponsorships'), ['action' => 'index', 'controller' => 'golf_sponsorships'], ['class' => 'side-nav-item']) ?>
                <?= $this->Html->link(__('Golf Day settings'), ['action' => 'index', 'controller' => 'golf_settings'], ['class' => 'side-nav-item']) ?>
                <?= $this->Html->link(__('Car Challenge signups'), ['action' => 'index', 'controller' => 'cars'], ['class' => 'side-nav-item']) ?>
                <?= $this->Html->link(__('Car Challenge settings'), ['action' => 'index', 'controller' => 'car_settings'], ['class' => 'side-nav-item']) ?>
                <div class="separator"></div>
                <h6>Online shop</h6>
                <?= $this->Html->link(__('Online shop orders'), ['action' => 'index', 'controller' => 'orders'], ['class' => 'side-nav-item']) ?>
                <?= $this->Html->link(__('Online shop products'), ['action' => 'index', 'controller' => 'products'], ['class' => 'side-nav-item']) ?>
                <div class="separator"></div>
                <h6>Admin</h6>
                <?= $this->Html->link(__('Titles'), ['action' => 'index', 'controller' => 'titles'], ['class' => 'side-nav-item']) ?>
                <?= $this->Html->link(__('Countries'), ['action' => 'index', 'controller' => 'countries'], ['class' => 'side-nav-item']) ?>
            </div>
            <div class="column">
                <div class="container">
                    <?= $this->Flash->render() ?>
                    <?= $this->fetch('content') ?>
                </div>
            </div>
        </div>
    </main>
    <footer>
    </footer>
</body>

</html>