<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Registration $registration
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Registration'), ['action' => 'edit', $registration->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Registration'), ['action' => 'delete', $registration->id], ['confirm' => __('Are you sure you want to delete # {0}?', $registration->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Registrations'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="registrations view content">
            <h3>View event</h3>
            <table>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($registration->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Title') ?></th>
                    <td><?php echo $registration->title->name; ?></td>
                </tr>
                <tr>
                    <th><?= __('Title Other') ?></th>
                    <td><?= h($registration->title_other) ?></td>
                </tr>
                <tr>
                    <th><?= __('First Name') ?></th>
                    <td><?= h($registration->first_name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Surname') ?></th>
                    <td><?= h($registration->surname) ?></td>
                </tr>
                <tr>
                    <th><?= __('Address 1') ?></th>
                    <td><?= h($registration->address_1) ?></td>
                </tr>
                <tr>
                    <th><?= __('Address 2') ?></th>
                    <td><?= h($registration->address_2) ?></td>
                </tr>
                <tr>
                    <th><?= __('City') ?></th>
                    <td><?= h($registration->city) ?></td>
                </tr>
                <tr>
                    <th><?= __('County') ?></th>
                    <td><?= h($registration->county) ?></td>
                </tr>
                <tr>
                    <th><?= __('Postal Code') ?></th>
                    <td><?= h($registration->postal_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Country') ?></th>
                    <td><?= $registration->hasValue('country') ? $this->Html->link($registration->country->name, ['controller' => 'Countries', 'action' => 'view', $registration->country->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Email') ?></th>
                    <td><?= h($registration->email) ?></td>
                </tr>
                <tr>
                    <th><?= __('Email Confirm') ?></th>
                    <td><?= h($registration->email_confirm) ?></td>
                </tr>
                <tr>
                    <th><?= __('Telephone') ?></th>
                    <td><?= h($registration->telephone) ?></td>
                </tr>
                <tr>
                    <th><?= __('Mobile') ?></th>
                    <td><?= h($registration->mobile) ?></td>
                </tr>
                <tr>
                    <th><?= __('Emergency Contact') ?></th>
                    <td><?= h($registration->emergency_contact) ?></td>
                </tr>
                <tr>
                    <th><?= __('Emergency Contact Number') ?></th>
                    <td><?= h($registration->emergency_contact_number) ?></td>
                </tr>
                <tr>
                    <th><?= __('Event') ?></th>
                    <td><?= $registration->hasValue('event') ? $this->Html->link($registration->event->name, ['controller' => 'Events', 'action' => 'view', $registration->event->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Custom Field 1') ?></th>
                    <td><?= h($registration->custom_field_1) ?></td>
                </tr>
                <tr>
                    <th><?= __('Custom Field 2') ?></th>
                    <td><?= h($registration->custom_field_2) ?></td>
                </tr>
                <tr>
                    <th><?= __('Organisation') ?></th>
                    <td><?= h($registration->organisation) ?></td>
                </tr>
                <tr>
                    <th><?= __('Heard About') ?></th>
                    <td><?= h($registration->heard_about) ?></td>
                </tr>
                <tr>
                    <th><?= __('Heard About Other') ?></th>
                    <td><?= h($registration->heard_about_other) ?></td>
                </tr>
                <tr>
                    <th><?= __('Date Of Birth') ?></th>
                    <td><?= h($registration->date_of_birth) ?></td>
                </tr>
                <tr>
                    <th><?= __('Amount') ?></th>
                    <td>&pound;<?= $this->Number->format($registration->amount, ['places' => 2]) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Status') ?></th>
                    <td><?= h($registration->tx_status) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Status Detail') ?></th>
                    <td><?= h($registration->tx_status_detail) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Code') ?></th>
                    <td><?= h($registration->tx_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Sagepay Id') ?></th>
                    <td><?= h($registration->tx_sagepay_id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Cardtype') ?></th>
                    <td><?= h($registration->tx_cardtype) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Card Lastdigits') ?></th>
                    <td><?= $this->Number->format($registration->tx_card_lastdigits) ?></td>
                </tr>
                <tr>
                    <th><?= __('Decline Code') ?></th>
                    <td><?= h($registration->decline_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Expiry Date') ?></th>
                    <td><?= h($registration->expiry_date) ?></td>
                </tr>
                <tr>
                    <th><?= __('Bank Auth Code') ?></th>
                    <td><?= h($registration->bank_auth_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Created') ?></th>
                    <td><?= h($registration->created) ?></td>
                </tr>
                <tr>
                    <th><?= __('Modified') ?></th>
                    <td><?= h($registration->modified) ?></td>
                </tr>
                <tr>
                    <th><?= __('Disclaimer') ?></th>
                    <td><?= $registration->disclaimer ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Is Mail Sent') ?></th>
                    <td><?= $registration->is_mail_sent ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('No Email') ?></th>
                    <td><?= $registration->no_email ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('No Telephone') ?></th>
                    <td><?= $registration->no_telephone ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('No Letter') ?></th>
                    <td><?= $registration->no_letter ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Optin Email') ?></th>
                    <td><?= $registration->optin_email ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Optin Telephone') ?></th>
                    <td><?= $registration->optin_telephone ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Optin Letter') ?></th>
                    <td><?= $registration->optin_letter ? __('Yes') : __('No'); ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('Medical Conditions') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($registration->medical_conditions)); ?>
                </blockquote>
            </div>
            <div class="text">
                <strong><?= __('Additional Guests') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($registration->additional_guests)); ?>
                </blockquote>
            </div>
            <div class="related">
                <h4><?= __('Related Tickets') ?></h4>
                <?php if (!empty($registration->tickets)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th>Ticket</th>
                            <th>Price</th>
                            <th>Amount</th>
                            <th>Sub-total</th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($registration->tickets as $tickets) : ?>
                        <tr>
                            <td><?php echo $tickets->event_cost->name; ?></td>
                            <td>&pound;<?php echo $tickets->event_cost->price; ?></td>
                            <td><?php echo $tickets->amount; ?></td>
                            <td>&pound;<?php echo number_format($tickets->amount * $tickets->event_cost->price, 2); ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Tickets', 'action' => 'view', $tickets->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Tickets', 'action' => 'edit', $tickets->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Tickets', 'action' => 'delete', $tickets->id], ['confirm' => __('Are you sure you want to delete # {0}?', $tickets->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
