<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Reason $reason
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Reason'), ['action' => 'edit', $reason->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Reason'), ['action' => 'delete', $reason->id], ['confirm' => __('Are you sure you want to delete # {0}?', $reason->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Reasons'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Reason'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="reasons view content">
            <h3><?= h($reason->name) ?></h3>
            <table>
                <tr>
                    <th><?= __('Name') ?></th>
                    <td><?= h($reason->name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($reason->id) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
