<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Product $product
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $product->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $product->id), 'class' => 'side-nav-item'],
            ) ?>
            <?= $this->Html->link(__('List Products'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="products form content">
            <?= $this->Form->create($product, ['enctype' => 'multipart/form-data']) ?>
            <fieldset>
                <legend><?= __('Edit Product') ?></legend>
                <?php
                echo $this->Form->control('name');
                echo $this->Form->control('price');
                echo $this->Form->control('description');
                echo $this->Form->control('active');
                ?>
                <label>Current image:</label>
                <?php echo $this->Html->image('products/' . $product->image, [
                    'width' => '200',
                ]); ?>
                <?php echo $this->Form->control('upload', ['type' => 'file', 'label' => 'Upload new image']); ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
