<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Order $order
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Order'), ['action' => 'edit', $order->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(
                __('Delete Order'),
                ['action' => 'delete', $order->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $order->id), 'class' => 'side-nav-item'],
            ) ?>
            <?= $this->Html->link(__('List Orders'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="orders view content">
            <div class="related">
                <h4><?= __('Related Order Items') ?></h4>
                <?php if (!empty($order->order_items)): ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Product') ?></th>
                            <th><?= __('Quantity') ?></th>
                            <th><?= __('Price') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($order->order_items as $orderItems): ?>
                        <tr>
                            <td><?= h($orderItems->product->name) ?></td>
                            <td><?= h($orderItems->quantity) ?></td>
                            <td><?= h($orderItems->price) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), [
                                    'controller' => 'OrderItems',
                                    'action' => 'view',
                                    $orderItems->id,
                                ]) ?>
                                <?= $this->Html->link(__('Edit'), [
                                    'controller' => 'OrderItems',
                                    'action' => 'edit',
                                    $orderItems->id,
                                ]) ?>
                                <?= $this->Form->postLink(
                                    __('Delete'),
                                    ['controller' => 'OrderItems', 'action' => 'delete', $orderItems->id],
                                    ['confirm' => __('Are you sure you want to delete # {0}?', $orderItems->id)],
                                ) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            <h3>Order details</h3>
            <table>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($order->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Amount') ?></th>
                    <td>&pound;<?= $this->Number->format($order->amount, ['places' => 2]) ?></td>
                </tr>
                <tr>
                    <th><?= __('Paid') ?></th>
                    <td><?= $order->paid ? __('Yes') : __('No') ?></td>
                </tr>
                <tr>
                    <th><?= __('Created') ?></th>
                    <td><?= h($order->created) ?></td>
                </tr>
                <tr>
                    <th><?= __('Modified') ?></th>
                    <td><?= h($order->modified) ?></td>
                </tr>
                <tr>
                    <td colspan="100%"><h3>Billing Details</h3></td>
                </tr>
                <tr>
                    <th><?= __('Title') ?></th>
                    <td><?= $order->hasValue('title')
                        ? $this->Html->link($order->title->name, [
                            'controller' => 'Titles',
                            'action' => 'view',
                            $order->title->id,
                        ])
                        : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Title Other') ?></th>
                    <td><?= h($order->title_other) ?></td>
                </tr>
                <tr>
                    <th><?= __('First Name') ?></th>
                    <td><?= h($order->first_name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Surname') ?></th>
                    <td><?= h($order->surname) ?></td>
                </tr>
                <tr>
                    <th><?= __('Address 1') ?></th>
                    <td><?= h($order->address_1) ?></td>
                </tr>
                <tr>
                    <th><?= __('Address 2') ?></th>
                    <td><?= h($order->address_2) ?></td>
                </tr>
                <tr>
                    <th><?= __('City') ?></th>
                    <td><?= h($order->city) ?></td>
                </tr>
                <tr>
                    <th><?= __('County') ?></th>
                    <td><?= h($order->county) ?></td>
                </tr>
                <tr>
                    <th><?= __('Postal Code') ?></th>
                    <td><?= h($order->postal_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Country') ?></th>
                    <td><?= $order->hasValue('country')
                        ? $this->Html->link($order->country->name, [
                            'controller' => 'Countries',
                            'action' => 'view',
                            $order->country->id,
                        ])
                        : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Email') ?></th>
                    <td><?= h($order->email) ?></td>
                </tr>
                <tr>
                    <th><?= __('Email Confirm') ?></th>
                    <td><?= h($order->email_confirm) ?></td>
                </tr>
                <tr>
                    <th><?= __('Telephone') ?></th>
                    <td><?= h($order->telephone) ?></td>
                </tr>
                <tr>
                    <th><?= __('Mobile Phone') ?></th>
                    <td><?= h($order->mobile_phone) ?></td>
                </tr>
                <tr>
                    <th><?= __('No Email') ?></th>
                    <td><?= $order->no_email ? __('Yes') : __('No') ?></td>
                </tr>
                <tr>
                    <th><?= __('No Telephone') ?></th>
                    <td><?= $order->no_telephone ? __('Yes') : __('No') ?></td>
                </tr>
                <tr>
                    <th><?= __('No Letter') ?></th>
                    <td><?= $order->no_letter ? __('Yes') : __('No') ?></td>
                </tr>
                <tr>
                    <th><?= __('Optin Email') ?></th>
                    <td><?= $order->optin_email ? __('Yes') : __('No') ?></td>
                </tr>
                <tr>
                    <th><?= __('Optin Telephone') ?></th>
                    <td><?= $order->optin_telephone ? __('Yes') : __('No') ?></td>
                </tr>
                <tr>
                    <th><?= __('Optin Letter') ?></th>
                    <td><?= $order->optin_letter ? __('Yes') : __('No') ?></td>
                </tr>
                <tr>
                    <th><?= __('Is Mail Sent') ?></th>
                    <td><?= $order->is_mail_sent ? __('Yes') : __('No') ?></td>
                </tr>
                <tr>
                    <td colspan="100%"><h3>Delivery details</h3></td>
                </tr>
                <tr>
                    <th><?= __('Delivery title') ?></th>
                    <td><?= $order->delivery_title->name ?></td>
                </tr>
                <tr>
                    <th><?= __('Delivery Title Other') ?></th>
                    <td><?= h($order->d_title_other) ?></td>
                </tr>
                <tr>
                    <th><?= __('Delivery First Name') ?></th>
                    <td><?= h($order->d_first_name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Delivery Surname') ?></th>
                    <td><?= h($order->d_surname) ?></td>
                </tr>
                <tr>
                    <th><?= __('Delivery Address 1') ?></th>
                    <td><?= h($order->d_address_1) ?></td>
                </tr>
                <tr>
                    <th><?= __('Delivery Address 2') ?></th>
                    <td><?= h($order->d_address_2) ?></td>
                </tr>
                <tr>
                    <th><?= __('Delivery City') ?></th>
                    <td><?= h($order->d_city) ?></td>
                </tr>
                <tr>
                    <th><?= __('Delivery County') ?></th>
                    <td><?= h($order->d_county) ?></td>
                </tr>
                <tr>
                    <th><?= __('Delivery Postal Code') ?></th>
                    <td><?= h($order->d_postal_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Delivery country') ?></th>
                    <td><?= $order->delivery_country->name ?></td>
                </tr>
                <tr>
                    <td colspan="100%"><h3>Transaction details</h3></td>
                </tr>
                <tr>
                    <th><?= __('Tx Status') ?></th>
                    <td><?= h($order->tx_status) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Status Detail') ?></th>
                    <td><?= h($order->tx_status_detail) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Code') ?></th>
                    <td><?= h($order->tx_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Sagepay Id') ?></th>
                    <td><?= h($order->tx_sagepay_id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Cardtype') ?></th>
                    <td><?= h($order->tx_cardtype) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Card Lastdigits') ?></th>
                    <td><?= $this->Number->format($order->tx_card_lastdigits) ?></td>
                </tr>
                <tr>
                    <th><?= __('Decline Code') ?></th>
                    <td><?= h($order->decline_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Expiry Date') ?></th>
                    <td><?= h($order->expiry_date) ?></td>
                </tr>
                <tr>
                    <th><?= __('Bank Auth Code') ?></th>
                    <td><?= h($order->bank_auth_code) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>