<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Light $light
 * @var string[]|\Cake\Collection\CollectionInterface $titles
 * @var string[]|\Cake\Collection\CollectionInterface $countries
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $light->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $light->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Lights'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="lights form content">
            <?= $this->Form->create($light) ?>
            <fieldset>
                <legend><?= __('Edit Light') ?></legend>
                <?php
                    echo $this->Form->control('donation_amount');
                    echo $this->Form->control('message');
                    echo $this->Form->control('homes');
                    echo $this->Form->control('gift_aid_for');
                    echo $this->Form->control('gift_aid_understood');
                    echo $this->Form->control('title_id', ['options' => $titles]);
                    echo $this->Form->control('title_other');
                    echo $this->Form->control('first_name');
                    echo $this->Form->control('surname');
                    echo $this->Form->control('address_1');
                    echo $this->Form->control('address_2');
                    echo $this->Form->control('city');
                    echo $this->Form->control('county');
                    echo $this->Form->control('postal_code');
                    echo $this->Form->control('country_id', ['options' => $countries]);
                    echo $this->Form->control('state_code');
                    echo $this->Form->control('email');
                    echo $this->Form->control('email_confirm');
                    echo $this->Form->control('telephone');
                    echo $this->Form->control('mobile_phone');
                    echo $this->Form->control('no_email');
                    echo $this->Form->control('no_telephone');
                    echo $this->Form->control('no_letter');
                    echo $this->Form->control('optin_email');
                    echo $this->Form->control('optin_telephone');
                    echo $this->Form->control('optin_letter');
                    echo $this->Form->control('tx_status');
                    echo $this->Form->control('tx_status_detail');
                    echo $this->Form->control('tx_code');
                    echo $this->Form->control('tx_sagepay_id');
                    echo $this->Form->control('tx_cardtype');
                    echo $this->Form->control('tx_card_lastdigits');
                    echo $this->Form->control('is_mail_sent');
                    echo $this->Form->control('decline_code');
                    echo $this->Form->control('expiry_date');
                    echo $this->Form->control('bank_auth_code');
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
