<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Golf $golf
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Golf'), ['action' => 'edit', $golf->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Golf'), ['action' => 'delete', $golf->id], ['confirm' => __('Are you sure you want to delete # {0}?', $golf->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Golfs'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="golfs view content">
            <h3><?= h($golf->p1_title_other) ?></h3>
            <table>
                <tr>
                    <th><?= __('Golf Type') ?></th>
                    <td><?= $golf->golf_type->name ?></td>
                </tr>
                <tr>
                    <th><?= __('Amount') ?></th>
                    <td>&pound;<?= $this->Number->format($golf->amount, ['places' => 2]) ?></td>
                </tr>
                <tr>
                    <th><?= __('Paid') ?></th>
                    <td><?= $golf->paid ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Heard About') ?></th>
                    <td><?= h($golf->heard_about) ?></td>
                </tr>
                <tr>
                    <th><?= __('Heard About Other') ?></th>
                    <td><?= h($golf->heard_about_other) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Status') ?></th>
                    <td><?= h($golf->tx_status) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Status Detail') ?></th>
                    <td><?= h($golf->tx_status_detail) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Code') ?></th>
                    <td><?= h($golf->tx_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Sagepay Id') ?></th>
                    <td><?= h($golf->tx_sagepay_id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Cardtype') ?></th>
                    <td><?= h($golf->tx_cardtype) ?></td>
                </tr>
                <tr>
                    <th><?= __('Decline Code') ?></th>
                    <td><?= h($golf->decline_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Expiry Date') ?></th>
                    <td><?= h($golf->expiry_date) ?></td>
                </tr>
                <tr>
                    <th><?= __('Bank Auth Code') ?></th>
                    <td><?= h($golf->bank_auth_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($golf->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Card Lastdigits') ?></th>
                    <td><?= $this->Number->format($golf->tx_card_lastdigits) ?></td>
                </tr>
                <tr>
                    <th><?= __('Created') ?></th>
                    <td><?= h($golf->created) ?></td>
                </tr>
                <tr>
                    <th><?= __('Modified') ?></th>
                    <td><?= h($golf->modified) ?></td>
                </tr>
                <tr>
                    <th><?= __('Is Mail Sent') ?></th>
                    <td><?= $golf->is_mail_sent ? __('Yes') : __('No'); ?></td>
                </tr>
            </table>
            <div class="related">
                <h4><?= __('Related Golf Players') ?></h4>
                <?php if (!empty($golf->golf_players)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('First Name') ?></th>
                            <th><?= __('Surname') ?></th>
                            <th><?= __('Organisation') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($golf->golf_players as $golfPlayers) : ?>
                        <tr>
                            <td><?= h($golfPlayers->id) ?></td>
                            <td><?= h($golfPlayers->first_name) ?></td>
                            <td><?= h($golfPlayers->surname) ?></td>
                            <td><?= h($golfPlayers->organisation) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'GolfPlayers', 'action' => 'view', $golfPlayers->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'GolfPlayers', 'action' => 'edit', $golfPlayers->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'GolfPlayers', 'action' => 'delete', $golfPlayers->id], ['confirm' => __('Are you sure you want to delete # {0}?', $golfPlayers->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
