<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Golf> $golfs
 */
?>
<div class="golfs index content">
    <?= $this->Html->link(
        __('Download CSV'),
        ['action' => 'csv'],
        ['class' => 'button float-right', 'style' => 'margin-right: 5px;'],
    ) ?>
    <h3><?= __('Golfs') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('golf_type_id') ?></th>
                    <th>Player 1 name</th>
                    <th><?= $this->Paginator->sort('created') ?></th>
                    <th><?= $this->Paginator->sort('paid') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($golfs as $golf): ?>
                <tr>
                    <td><?= $this->Number->format($golf->id) ?></td>
                    <td><?= $golf->golf_type->name ?></td>
                    <td><?php echo $golf->golf_players[0]->fullName(); ?></td>
                    <td><?= h($golf->created) ?></td>
                    <td><?php echo $golf->paid ? 'Y' : 'N'; ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $golf->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $golf->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $golf->id], ['confirm' => __('Are you sure you want to delete # {0}?', $golf->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
