<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\GolfType> $golfTypes
 */
?>
<div class="golfTypes index content">
    <?= $this->Html->link(__('New Golf Type'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Golf Types') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('name') ?></th>
                    <th><?= $this->Paginator->sort('price') ?></th>
                    <th><?= $this->Paginator->sort('players') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($golfTypes as $golfType): ?>
                <tr>
                    <td><?= $this->Number->format($golfType->id) ?></td>
                    <td><?= $golfType->name ?></td>
                    <td>&pound;<?= $this->Number->format($golfType->price, ['places' => 2]) ?></td>
                    <td><?= $this->Number->format($golfType->players) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $golfType->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $golfType->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $golfType->id], ['confirm' => __('Are you sure you want to delete # {0}?', $golfType->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
