<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\GolfSetting> $golfSettings
 */
?>
<div class="golfSettings index content">
    <?= $this->Html->link(__('New Golf Setting'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Golf Settings') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($golfSettings as $golfSetting): ?>
                <tr>
                    <td><?= $this->Number->format($golfSetting->id) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $golfSetting->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $golfSetting->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $golfSetting->id], ['confirm' => __('Are you sure you want to delete # {0}?', $golfSetting->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
