<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\GolfPlayer $golfPlayer
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Golf Player'), ['action' => 'edit', $golfPlayer->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Golf Player'), ['action' => 'delete', $golfPlayer->id], ['confirm' => __('Are you sure you want to delete # {0}?', $golfPlayer->id), 'class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="golfPlayers view content">
            <h3><?= h($golfPlayer->title_other) ?></h3>
            <table>
                <tr>
                    <th><?= __('Golf') ?></th>
                    <td><?= $golfPlayer->hasValue('golf') ? $this->Html->link($golfPlayer->golf->p1_title_other, ['controller' => 'Golfs', 'action' => 'view', $golfPlayer->golf->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Title') ?></th>
                    <td><?= $golfPlayer->hasValue('title') ? $this->Html->link($golfPlayer->title->name, ['controller' => 'Titles', 'action' => 'view', $golfPlayer->title->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Title Other') ?></th>
                    <td><?= h($golfPlayer->title_other) ?></td>
                </tr>
                <tr>
                    <th><?= __('First Name') ?></th>
                    <td><?= h($golfPlayer->first_name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Surname') ?></th>
                    <td><?= h($golfPlayer->surname) ?></td>
                </tr>
                <tr>
                    <th><?= __('Organisation') ?></th>
                    <td><?= h($golfPlayer->organisation) ?></td>
                </tr>
                <tr>
                    <th><?= __('Address 1') ?></th>
                    <td><?= h($golfPlayer->address_1) ?></td>
                </tr>
                <tr>
                    <th><?= __('Address 2') ?></th>
                    <td><?= h($golfPlayer->address_2) ?></td>
                </tr>
                <tr>
                    <th><?= __('City') ?></th>
                    <td><?= h($golfPlayer->city) ?></td>
                </tr>
                <tr>
                    <th><?= __('County') ?></th>
                    <td><?= h($golfPlayer->county) ?></td>
                </tr>
                <tr>
                    <th><?= __('Postal Code') ?></th>
                    <td><?= h($golfPlayer->postal_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Country') ?></th>
                    <td><?= $golfPlayer->hasValue('country') ? $this->Html->link($golfPlayer->country->name, ['controller' => 'Countries', 'action' => 'view', $golfPlayer->country->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('State Code') ?></th>
                    <td><?= h($golfPlayer->state_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Email') ?></th>
                    <td><?= h($golfPlayer->email) ?></td>
                </tr>
                <tr>
                    <th><?= __('Email Confirm') ?></th>
                    <td><?= h($golfPlayer->email_confirm) ?></td>
                </tr>
                <tr>
                    <th><?= __('Telephone') ?></th>
                    <td><?= h($golfPlayer->telephone) ?></td>
                </tr>
                <tr>
                    <th><?= __('Mobile Phone') ?></th>
                    <td><?= h($golfPlayer->mobile_phone) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($golfPlayer->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Created') ?></th>
                    <td><?= h($golfPlayer->created) ?></td>
                </tr>
                <tr>
                    <th><?= __('Modified') ?></th>
                    <td><?= h($golfPlayer->modified) ?></td>
                </tr>
                <tr>
                    <th><?= __('No Email') ?></th>
                    <td><?= $golfPlayer->no_email ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('No Telephone') ?></th>
                    <td><?= $golfPlayer->no_telephone ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('No Letter') ?></th>
                    <td><?= $golfPlayer->no_letter ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Optin Email') ?></th>
                    <td><?= $golfPlayer->optin_email ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Optin Telephone') ?></th>
                    <td><?= $golfPlayer->optin_telephone ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Optin Letter') ?></th>
                    <td><?= $golfPlayer->optin_letter ? __('Yes') : __('No'); ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('Dietary Requirements') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($golfPlayer->dietary_requirements)); ?>
                </blockquote>
            </div>
        </div>
    </div>
</div>
