<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\GolfPlayer> $golfPlayers
 */
?>
<div class="golfPlayers index content">
    <?= $this->Html->link(__('New Golf Player'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Golf Players') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('golf_id') ?></th>
                    <th><?= $this->Paginator->sort('title_id') ?></th>
                    <th><?= $this->Paginator->sort('title_other') ?></th>
                    <th><?= $this->Paginator->sort('first_name') ?></th>
                    <th><?= $this->Paginator->sort('surname') ?></th>
                    <th><?= $this->Paginator->sort('organisation') ?></th>
                    <th><?= $this->Paginator->sort('address_1') ?></th>
                    <th><?= $this->Paginator->sort('address_2') ?></th>
                    <th><?= $this->Paginator->sort('city') ?></th>
                    <th><?= $this->Paginator->sort('county') ?></th>
                    <th><?= $this->Paginator->sort('postal_code') ?></th>
                    <th><?= $this->Paginator->sort('country_id') ?></th>
                    <th><?= $this->Paginator->sort('state_code') ?></th>
                    <th><?= $this->Paginator->sort('email') ?></th>
                    <th><?= $this->Paginator->sort('email_confirm') ?></th>
                    <th><?= $this->Paginator->sort('telephone') ?></th>
                    <th><?= $this->Paginator->sort('mobile_phone') ?></th>
                    <th><?= $this->Paginator->sort('no_email') ?></th>
                    <th><?= $this->Paginator->sort('no_telephone') ?></th>
                    <th><?= $this->Paginator->sort('no_letter') ?></th>
                    <th><?= $this->Paginator->sort('optin_email') ?></th>
                    <th><?= $this->Paginator->sort('optin_telephone') ?></th>
                    <th><?= $this->Paginator->sort('optin_letter') ?></th>
                    <th><?= $this->Paginator->sort('created') ?></th>
                    <th><?= $this->Paginator->sort('modified') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($golfPlayers as $golfPlayer): ?>
                <tr>
                    <td><?= $this->Number->format($golfPlayer->id) ?></td>
                    <td><?= $golfPlayer->hasValue('golf') ? $this->Html->link($golfPlayer->golf->p1_title_other, ['controller' => 'Golfs', 'action' => 'view', $golfPlayer->golf->id]) : '' ?></td>
                    <td><?= $golfPlayer->hasValue('title') ? $this->Html->link($golfPlayer->title->name, ['controller' => 'Titles', 'action' => 'view', $golfPlayer->title->id]) : '' ?></td>
                    <td><?= h($golfPlayer->title_other) ?></td>
                    <td><?= h($golfPlayer->first_name) ?></td>
                    <td><?= h($golfPlayer->surname) ?></td>
                    <td><?= h($golfPlayer->organisation) ?></td>
                    <td><?= h($golfPlayer->address_1) ?></td>
                    <td><?= h($golfPlayer->address_2) ?></td>
                    <td><?= h($golfPlayer->city) ?></td>
                    <td><?= h($golfPlayer->county) ?></td>
                    <td><?= h($golfPlayer->postal_code) ?></td>
                    <td><?= $golfPlayer->hasValue('country') ? $this->Html->link($golfPlayer->country->name, ['controller' => 'Countries', 'action' => 'view', $golfPlayer->country->id]) : '' ?></td>
                    <td><?= h($golfPlayer->state_code) ?></td>
                    <td><?= h($golfPlayer->email) ?></td>
                    <td><?= h($golfPlayer->email_confirm) ?></td>
                    <td><?= h($golfPlayer->telephone) ?></td>
                    <td><?= h($golfPlayer->mobile_phone) ?></td>
                    <td><?= h($golfPlayer->no_email) ?></td>
                    <td><?= h($golfPlayer->no_telephone) ?></td>
                    <td><?= h($golfPlayer->no_letter) ?></td>
                    <td><?= h($golfPlayer->optin_email) ?></td>
                    <td><?= h($golfPlayer->optin_telephone) ?></td>
                    <td><?= h($golfPlayer->optin_letter) ?></td>
                    <td><?= h($golfPlayer->created) ?></td>
                    <td><?= h($golfPlayer->modified) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $golfPlayer->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $golfPlayer->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $golfPlayer->id], ['confirm' => __('Are you sure you want to delete # {0}?', $golfPlayer->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
