<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\GolfPlayer $golfPlayer
 * @var \Cake\Collection\CollectionInterface|string[] $golfs
 * @var \Cake\Collection\CollectionInterface|string[] $titles
 * @var \Cake\Collection\CollectionInterface|string[] $countries
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('List Golf Players'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="golfPlayers form content">
            <?= $this->Form->create($golfPlayer) ?>
            <fieldset>
                <legend><?= __('Add Golf Player') ?></legend>
                <?php
                    echo $this->Form->control('golf_id', ['options' => $golfs]);
                    echo $this->Form->control('title_id', ['options' => $titles]);
                    echo $this->Form->control('title_other');
                    echo $this->Form->control('first_name');
                    echo $this->Form->control('surname');
                    echo $this->Form->control('organisation');
                    echo $this->Form->control('address_1');
                    echo $this->Form->control('address_2');
                    echo $this->Form->control('city');
                    echo $this->Form->control('county');
                    echo $this->Form->control('postal_code');
                    echo $this->Form->control('country_id', ['options' => $countries]);
                    echo $this->Form->control('state_code');
                    echo $this->Form->control('email');
                    echo $this->Form->control('email_confirm');
                    echo $this->Form->control('telephone');
                    echo $this->Form->control('mobile_phone');
                    echo $this->Form->control('dietary_requirements');
                    echo $this->Form->control('no_email');
                    echo $this->Form->control('no_telephone');
                    echo $this->Form->control('no_letter');
                    echo $this->Form->control('optin_email');
                    echo $this->Form->control('optin_telephone');
                    echo $this->Form->control('optin_letter');
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
