<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\EventCost $eventCost
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Event Cost'), ['action' => 'edit', $eventCost->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Event Cost'), ['action' => 'delete', $eventCost->id], ['confirm' => __('Are you sure you want to delete # {0}?', $eventCost->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Event Costs'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Event Cost'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="eventCosts view content">
            <h3><?= h($eventCost->name) ?></h3>
            <table>
                <tr>
                    <th><?= __('Event') ?></th>
                    <td><?= $eventCost->hasValue('event') ? $this->Html->link($eventCost->event->name, ['controller' => 'Events', 'action' => 'view', $eventCost->event->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Name') ?></th>
                    <td><?= h($eventCost->name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($eventCost->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Price') ?></th>
                    <td><?= $this->Number->format($eventCost->price) ?></td>
                </tr>
            </table>
            <div class="related">
                <h4><?= __('Related Registrations') ?></h4>
                <?php if (!empty($eventCost->registrations)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Amount') ?></th>
                            <th><?= __('Age On Race') ?></th>
                            <th><?= __('Date Of Birth') ?></th>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Title Id') ?></th>
                            <th><?= __('Title Other') ?></th>
                            <th><?= __('First Name') ?></th>
                            <th><?= __('Surname') ?></th>
                            <th><?= __('Address 1') ?></th>
                            <th><?= __('Address 2') ?></th>
                            <th><?= __('City') ?></th>
                            <th><?= __('County') ?></th>
                            <th><?= __('Postal Code') ?></th>
                            <th><?= __('Country Id') ?></th>
                            <th><?= __('Email') ?></th>
                            <th><?= __('Email Confirm') ?></th>
                            <th><?= __('Telephone') ?></th>
                            <th><?= __('Mobile') ?></th>
                            <th><?= __('Emergency Contact') ?></th>
                            <th><?= __('Emergency Contact Number') ?></th>
                            <th><?= __('Medical Conditions') ?></th>
                            <th><?= __('Disclaimer') ?></th>
                            <th><?= __('Tx Status') ?></th>
                            <th><?= __('Tx Status Detail') ?></th>
                            <th><?= __('Tx Code') ?></th>
                            <th><?= __('Tx Sagepay Id') ?></th>
                            <th><?= __('Tx Cardtype') ?></th>
                            <th><?= __('Tx Card Lastdigits') ?></th>
                            <th><?= __('Is Mail Sent') ?></th>
                            <th><?= __('Decline Code') ?></th>
                            <th><?= __('Expiry Date') ?></th>
                            <th><?= __('Bank Auth Code') ?></th>
                            <th><?= __('Created') ?></th>
                            <th><?= __('Modified') ?></th>
                            <th><?= __('Event Id') ?></th>
                            <th><?= __('Event Cost Id') ?></th>
                            <th><?= __('Custom Field 1') ?></th>
                            <th><?= __('Custom Field 2') ?></th>
                            <th><?= __('Organisation') ?></th>
                            <th><?= __('No Email') ?></th>
                            <th><?= __('No Telephone') ?></th>
                            <th><?= __('No Letter') ?></th>
                            <th><?= __('Optin Email') ?></th>
                            <th><?= __('Optin Telephone') ?></th>
                            <th><?= __('Optin Letter') ?></th>
                            <th><?= __('Additional Guests') ?></th>
                            <th><?= __('Heard About') ?></th>
                            <th><?= __('Heard About Other') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($eventCost->registrations as $registrations) : ?>
                        <tr>
                            <td><?= h($registrations->amount) ?></td>
                            <td><?= h($registrations->age_on_race) ?></td>
                            <td><?= h($registrations->date_of_birth) ?></td>
                            <td><?= h($registrations->id) ?></td>
                            <td><?= h($registrations->title_id) ?></td>
                            <td><?= h($registrations->title_other) ?></td>
                            <td><?= h($registrations->first_name) ?></td>
                            <td><?= h($registrations->surname) ?></td>
                            <td><?= h($registrations->address_1) ?></td>
                            <td><?= h($registrations->address_2) ?></td>
                            <td><?= h($registrations->city) ?></td>
                            <td><?= h($registrations->county) ?></td>
                            <td><?= h($registrations->postal_code) ?></td>
                            <td><?= h($registrations->country_id) ?></td>
                            <td><?= h($registrations->email) ?></td>
                            <td><?= h($registrations->email_confirm) ?></td>
                            <td><?= h($registrations->telephone) ?></td>
                            <td><?= h($registrations->mobile) ?></td>
                            <td><?= h($registrations->emergency_contact) ?></td>
                            <td><?= h($registrations->emergency_contact_number) ?></td>
                            <td><?= h($registrations->medical_conditions) ?></td>
                            <td><?= h($registrations->disclaimer) ?></td>
                            <td><?= h($registrations->tx_status) ?></td>
                            <td><?= h($registrations->tx_status_detail) ?></td>
                            <td><?= h($registrations->tx_code) ?></td>
                            <td><?= h($registrations->tx_sagepay_id) ?></td>
                            <td><?= h($registrations->tx_cardtype) ?></td>
                            <td><?= h($registrations->tx_card_lastdigits) ?></td>
                            <td><?= h($registrations->is_mail_sent) ?></td>
                            <td><?= h($registrations->decline_code) ?></td>
                            <td><?= h($registrations->expiry_date) ?></td>
                            <td><?= h($registrations->bank_auth_code) ?></td>
                            <td><?= h($registrations->created) ?></td>
                            <td><?= h($registrations->modified) ?></td>
                            <td><?= h($registrations->event_id) ?></td>
                            <td><?= h($registrations->event_cost_id) ?></td>
                            <td><?= h($registrations->custom_field_1) ?></td>
                            <td><?= h($registrations->custom_field_2) ?></td>
                            <td><?= h($registrations->organisation) ?></td>
                            <td><?= h($registrations->no_email) ?></td>
                            <td><?= h($registrations->no_telephone) ?></td>
                            <td><?= h($registrations->no_letter) ?></td>
                            <td><?= h($registrations->optin_email) ?></td>
                            <td><?= h($registrations->optin_telephone) ?></td>
                            <td><?= h($registrations->optin_letter) ?></td>
                            <td><?= h($registrations->additional_guests) ?></td>
                            <td><?= h($registrations->heard_about) ?></td>
                            <td><?= h($registrations->heard_about_other) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Registrations', 'action' => 'view', $registrations->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Registrations', 'action' => 'edit', $registrations->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Registrations', 'action' => 'delete', $registrations->id], ['confirm' => __('Are you sure you want to delete # {0}?', $registrations->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            <div class="related">
                <h4><?= __('Related Tickets') ?></h4>
                <?php if (!empty($eventCost->tickets)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Registration Id') ?></th>
                            <th><?= __('Event Cost Id') ?></th>
                            <th><?= __('Amount') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($eventCost->tickets as $tickets) : ?>
                        <tr>
                            <td><?= h($tickets->id) ?></td>
                            <td><?= h($tickets->registration_id) ?></td>
                            <td><?= h($tickets->event_cost_id) ?></td>
                            <td><?= h($tickets->amount) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Tickets', 'action' => 'view', $tickets->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Tickets', 'action' => 'edit', $tickets->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Tickets', 'action' => 'delete', $tickets->id], ['confirm' => __('Are you sure you want to delete # {0}?', $tickets->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
