<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Country $country
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Country'), ['action' => 'edit', $country->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Country'), ['action' => 'delete', $country->id], ['confirm' => __('Are you sure you want to delete # {0}?', $country->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Countries'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Country'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="countries view content">
            <h3><?= h($country->name) ?></h3>
            <table>
                <tr>
                    <th><?= __('Name') ?></th>
                    <td><?= h($country->name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Iso Code') ?></th>
                    <td><?= h($country->iso_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($country->id) ?></td>
                </tr>
            </table>
            <div class="related">
                <h4><?= __('Related Car Parts') ?></h4>
                <?php if (!empty($country->car_parts)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Car Id') ?></th>
                            <th><?= __('Title Id') ?></th>
                            <th><?= __('Title Other') ?></th>
                            <th><?= __('First Name') ?></th>
                            <th><?= __('Surname') ?></th>
                            <th><?= __('Organisation') ?></th>
                            <th><?= __('Address 1') ?></th>
                            <th><?= __('Address 2') ?></th>
                            <th><?= __('City') ?></th>
                            <th><?= __('County') ?></th>
                            <th><?= __('Postal Code') ?></th>
                            <th><?= __('Country Id') ?></th>
                            <th><?= __('State Code') ?></th>
                            <th><?= __('Email') ?></th>
                            <th><?= __('Email Confirm') ?></th>
                            <th><?= __('Telephone') ?></th>
                            <th><?= __('Mobile Phone') ?></th>
                            <th><?= __('No Email') ?></th>
                            <th><?= __('No Telephone') ?></th>
                            <th><?= __('No Letter') ?></th>
                            <th><?= __('Optin Email') ?></th>
                            <th><?= __('Optin Telephone') ?></th>
                            <th><?= __('Optin Letter') ?></th>
                            <th><?= __('Created') ?></th>
                            <th><?= __('Modified') ?></th>
                            <th><?= __('Date Of Birth') ?></th>
                            <th><?= __('Dietary') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($country->car_parts as $carParts) : ?>
                        <tr>
                            <td><?= h($carParts->id) ?></td>
                            <td><?= h($carParts->car_id) ?></td>
                            <td><?= h($carParts->title_id) ?></td>
                            <td><?= h($carParts->title_other) ?></td>
                            <td><?= h($carParts->first_name) ?></td>
                            <td><?= h($carParts->surname) ?></td>
                            <td><?= h($carParts->organisation) ?></td>
                            <td><?= h($carParts->address_1) ?></td>
                            <td><?= h($carParts->address_2) ?></td>
                            <td><?= h($carParts->city) ?></td>
                            <td><?= h($carParts->county) ?></td>
                            <td><?= h($carParts->postal_code) ?></td>
                            <td><?= h($carParts->country_id) ?></td>
                            <td><?= h($carParts->state_code) ?></td>
                            <td><?= h($carParts->email) ?></td>
                            <td><?= h($carParts->email_confirm) ?></td>
                            <td><?= h($carParts->telephone) ?></td>
                            <td><?= h($carParts->mobile_phone) ?></td>
                            <td><?= h($carParts->no_email) ?></td>
                            <td><?= h($carParts->no_telephone) ?></td>
                            <td><?= h($carParts->no_letter) ?></td>
                            <td><?= h($carParts->optin_email) ?></td>
                            <td><?= h($carParts->optin_telephone) ?></td>
                            <td><?= h($carParts->optin_letter) ?></td>
                            <td><?= h($carParts->created) ?></td>
                            <td><?= h($carParts->modified) ?></td>
                            <td><?= h($carParts->date_of_birth) ?></td>
                            <td><?= h($carParts->dietary) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'CarParts', 'action' => 'view', $carParts->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'CarParts', 'action' => 'edit', $carParts->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'CarParts', 'action' => 'delete', $carParts->id], ['confirm' => __('Are you sure you want to delete # {0}?', $carParts->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            <div class="related">
                <h4><?= __('Related Donations') ?></h4>
                <?php if (!empty($country->donations)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Donation Amount') ?></th>
                            <th><?= __('Gift Aid For') ?></th>
                            <th><?= __('Gift Aid Understood') ?></th>
                            <th><?= __('Title Id') ?></th>
                            <th><?= __('Title Other') ?></th>
                            <th><?= __('First Name') ?></th>
                            <th><?= __('Surname') ?></th>
                            <th><?= __('Address 1') ?></th>
                            <th><?= __('Address 2') ?></th>
                            <th><?= __('City') ?></th>
                            <th><?= __('County') ?></th>
                            <th><?= __('Postal Code') ?></th>
                            <th><?= __('Country Id') ?></th>
                            <th><?= __('State Code') ?></th>
                            <th><?= __('Email') ?></th>
                            <th><?= __('Email Confirm') ?></th>
                            <th><?= __('Telephone') ?></th>
                            <th><?= __('Mobile Phone') ?></th>
                            <th><?= __('No Email') ?></th>
                            <th><?= __('No Telephone') ?></th>
                            <th><?= __('No Letter') ?></th>
                            <th><?= __('Optin Email') ?></th>
                            <th><?= __('Optin Telephone') ?></th>
                            <th><?= __('Optin Letter') ?></th>
                            <th><?= __('Tx Status') ?></th>
                            <th><?= __('Tx Status Detail') ?></th>
                            <th><?= __('Tx Code') ?></th>
                            <th><?= __('Tx Sagepay Id') ?></th>
                            <th><?= __('Tx Cardtype') ?></th>
                            <th><?= __('Tx Card Lastdigits') ?></th>
                            <th><?= __('Is Mail Sent') ?></th>
                            <th><?= __('Decline Code') ?></th>
                            <th><?= __('Expiry Date') ?></th>
                            <th><?= __('Bank Auth Code') ?></th>
                            <th><?= __('Created') ?></th>
                            <th><?= __('Modified') ?></th>
                            <th><?= __('Organisation') ?></th>
                            <th><?= __('Message') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($country->donations as $donations) : ?>
                        <tr>
                            <td><?= h($donations->id) ?></td>
                            <td><?= h($donations->donation_amount) ?></td>
                            <td><?= h($donations->gift_aid_for) ?></td>
                            <td><?= h($donations->gift_aid_understood) ?></td>
                            <td><?= h($donations->title_id) ?></td>
                            <td><?= h($donations->title_other) ?></td>
                            <td><?= h($donations->first_name) ?></td>
                            <td><?= h($donations->surname) ?></td>
                            <td><?= h($donations->address_1) ?></td>
                            <td><?= h($donations->address_2) ?></td>
                            <td><?= h($donations->city) ?></td>
                            <td><?= h($donations->county) ?></td>
                            <td><?= h($donations->postal_code) ?></td>
                            <td><?= h($donations->country_id) ?></td>
                            <td><?= h($donations->state_code) ?></td>
                            <td><?= h($donations->email) ?></td>
                            <td><?= h($donations->email_confirm) ?></td>
                            <td><?= h($donations->telephone) ?></td>
                            <td><?= h($donations->mobile_phone) ?></td>
                            <td><?= h($donations->no_email) ?></td>
                            <td><?= h($donations->no_telephone) ?></td>
                            <td><?= h($donations->no_letter) ?></td>
                            <td><?= h($donations->optin_email) ?></td>
                            <td><?= h($donations->optin_telephone) ?></td>
                            <td><?= h($donations->optin_letter) ?></td>
                            <td><?= h($donations->tx_status) ?></td>
                            <td><?= h($donations->tx_status_detail) ?></td>
                            <td><?= h($donations->tx_code) ?></td>
                            <td><?= h($donations->tx_sagepay_id) ?></td>
                            <td><?= h($donations->tx_cardtype) ?></td>
                            <td><?= h($donations->tx_card_lastdigits) ?></td>
                            <td><?= h($donations->is_mail_sent) ?></td>
                            <td><?= h($donations->decline_code) ?></td>
                            <td><?= h($donations->expiry_date) ?></td>
                            <td><?= h($donations->bank_auth_code) ?></td>
                            <td><?= h($donations->created) ?></td>
                            <td><?= h($donations->modified) ?></td>
                            <td><?= h($donations->organisation) ?></td>
                            <td><?= h($donations->message) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Donations', 'action' => 'view', $donations->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Donations', 'action' => 'edit', $donations->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Donations', 'action' => 'delete', $donations->id], ['confirm' => __('Are you sure you want to delete # {0}?', $donations->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            <div class="related">
                <h4><?= __('Related Golf Players') ?></h4>
                <?php if (!empty($country->golf_players)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Golf Id') ?></th>
                            <th><?= __('Title Id') ?></th>
                            <th><?= __('Title Other') ?></th>
                            <th><?= __('First Name') ?></th>
                            <th><?= __('Surname') ?></th>
                            <th><?= __('Organisation') ?></th>
                            <th><?= __('Address 1') ?></th>
                            <th><?= __('Address 2') ?></th>
                            <th><?= __('City') ?></th>
                            <th><?= __('County') ?></th>
                            <th><?= __('Postal Code') ?></th>
                            <th><?= __('Country Id') ?></th>
                            <th><?= __('State Code') ?></th>
                            <th><?= __('Email') ?></th>
                            <th><?= __('Email Confirm') ?></th>
                            <th><?= __('Telephone') ?></th>
                            <th><?= __('Mobile Phone') ?></th>
                            <th><?= __('Dietary Requirements') ?></th>
                            <th><?= __('No Email') ?></th>
                            <th><?= __('No Telephone') ?></th>
                            <th><?= __('No Letter') ?></th>
                            <th><?= __('Optin Email') ?></th>
                            <th><?= __('Optin Telephone') ?></th>
                            <th><?= __('Optin Letter') ?></th>
                            <th><?= __('Created') ?></th>
                            <th><?= __('Modified') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($country->golf_players as $golfPlayers) : ?>
                        <tr>
                            <td><?= h($golfPlayers->id) ?></td>
                            <td><?= h($golfPlayers->golf_id) ?></td>
                            <td><?= h($golfPlayers->title_id) ?></td>
                            <td><?= h($golfPlayers->title_other) ?></td>
                            <td><?= h($golfPlayers->first_name) ?></td>
                            <td><?= h($golfPlayers->surname) ?></td>
                            <td><?= h($golfPlayers->organisation) ?></td>
                            <td><?= h($golfPlayers->address_1) ?></td>
                            <td><?= h($golfPlayers->address_2) ?></td>
                            <td><?= h($golfPlayers->city) ?></td>
                            <td><?= h($golfPlayers->county) ?></td>
                            <td><?= h($golfPlayers->postal_code) ?></td>
                            <td><?= h($golfPlayers->country_id) ?></td>
                            <td><?= h($golfPlayers->state_code) ?></td>
                            <td><?= h($golfPlayers->email) ?></td>
                            <td><?= h($golfPlayers->email_confirm) ?></td>
                            <td><?= h($golfPlayers->telephone) ?></td>
                            <td><?= h($golfPlayers->mobile_phone) ?></td>
                            <td><?= h($golfPlayers->dietary_requirements) ?></td>
                            <td><?= h($golfPlayers->no_email) ?></td>
                            <td><?= h($golfPlayers->no_telephone) ?></td>
                            <td><?= h($golfPlayers->no_letter) ?></td>
                            <td><?= h($golfPlayers->optin_email) ?></td>
                            <td><?= h($golfPlayers->optin_telephone) ?></td>
                            <td><?= h($golfPlayers->optin_letter) ?></td>
                            <td><?= h($golfPlayers->created) ?></td>
                            <td><?= h($golfPlayers->modified) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'GolfPlayers', 'action' => 'view', $golfPlayers->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'GolfPlayers', 'action' => 'edit', $golfPlayers->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'GolfPlayers', 'action' => 'delete', $golfPlayers->id], ['confirm' => __('Are you sure you want to delete # {0}?', $golfPlayers->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            <div class="related">
                <h4><?= __('Related Lights') ?></h4>
                <?php if (!empty($country->lights)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Donation Amount') ?></th>
                            <th><?= __('Message') ?></th>
                            <th><?= __('Homes') ?></th>
                            <th><?= __('Gift Aid For') ?></th>
                            <th><?= __('Gift Aid Understood') ?></th>
                            <th><?= __('Title Id') ?></th>
                            <th><?= __('Title Other') ?></th>
                            <th><?= __('First Name') ?></th>
                            <th><?= __('Surname') ?></th>
                            <th><?= __('Address 1') ?></th>
                            <th><?= __('Address 2') ?></th>
                            <th><?= __('City') ?></th>
                            <th><?= __('County') ?></th>
                            <th><?= __('Postal Code') ?></th>
                            <th><?= __('Country Id') ?></th>
                            <th><?= __('State Code') ?></th>
                            <th><?= __('Email') ?></th>
                            <th><?= __('Email Confirm') ?></th>
                            <th><?= __('Telephone') ?></th>
                            <th><?= __('Mobile Phone') ?></th>
                            <th><?= __('No Email') ?></th>
                            <th><?= __('No Telephone') ?></th>
                            <th><?= __('No Letter') ?></th>
                            <th><?= __('Optin Email') ?></th>
                            <th><?= __('Optin Telephone') ?></th>
                            <th><?= __('Optin Letter') ?></th>
                            <th><?= __('Tx Status') ?></th>
                            <th><?= __('Tx Status Detail') ?></th>
                            <th><?= __('Tx Code') ?></th>
                            <th><?= __('Tx Sagepay Id') ?></th>
                            <th><?= __('Tx Cardtype') ?></th>
                            <th><?= __('Tx Card Lastdigits') ?></th>
                            <th><?= __('Is Mail Sent') ?></th>
                            <th><?= __('Decline Code') ?></th>
                            <th><?= __('Expiry Date') ?></th>
                            <th><?= __('Bank Auth Code') ?></th>
                            <th><?= __('Created') ?></th>
                            <th><?= __('Modified') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($country->lights as $lights) : ?>
                        <tr>
                            <td><?= h($lights->id) ?></td>
                            <td><?= h($lights->donation_amount) ?></td>
                            <td><?= h($lights->message) ?></td>
                            <td><?= h($lights->homes) ?></td>
                            <td><?= h($lights->gift_aid_for) ?></td>
                            <td><?= h($lights->gift_aid_understood) ?></td>
                            <td><?= h($lights->title_id) ?></td>
                            <td><?= h($lights->title_other) ?></td>
                            <td><?= h($lights->first_name) ?></td>
                            <td><?= h($lights->surname) ?></td>
                            <td><?= h($lights->address_1) ?></td>
                            <td><?= h($lights->address_2) ?></td>
                            <td><?= h($lights->city) ?></td>
                            <td><?= h($lights->county) ?></td>
                            <td><?= h($lights->postal_code) ?></td>
                            <td><?= h($lights->country_id) ?></td>
                            <td><?= h($lights->state_code) ?></td>
                            <td><?= h($lights->email) ?></td>
                            <td><?= h($lights->email_confirm) ?></td>
                            <td><?= h($lights->telephone) ?></td>
                            <td><?= h($lights->mobile_phone) ?></td>
                            <td><?= h($lights->no_email) ?></td>
                            <td><?= h($lights->no_telephone) ?></td>
                            <td><?= h($lights->no_letter) ?></td>
                            <td><?= h($lights->optin_email) ?></td>
                            <td><?= h($lights->optin_telephone) ?></td>
                            <td><?= h($lights->optin_letter) ?></td>
                            <td><?= h($lights->tx_status) ?></td>
                            <td><?= h($lights->tx_status_detail) ?></td>
                            <td><?= h($lights->tx_code) ?></td>
                            <td><?= h($lights->tx_sagepay_id) ?></td>
                            <td><?= h($lights->tx_cardtype) ?></td>
                            <td><?= h($lights->tx_card_lastdigits) ?></td>
                            <td><?= h($lights->is_mail_sent) ?></td>
                            <td><?= h($lights->decline_code) ?></td>
                            <td><?= h($lights->expiry_date) ?></td>
                            <td><?= h($lights->bank_auth_code) ?></td>
                            <td><?= h($lights->created) ?></td>
                            <td><?= h($lights->modified) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Lights', 'action' => 'view', $lights->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Lights', 'action' => 'edit', $lights->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Lights', 'action' => 'delete', $lights->id], ['confirm' => __('Are you sure you want to delete # {0}?', $lights->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            <div class="related">
                <h4><?= __('Related Orders') ?></h4>
                <?php if (!empty($country->orders)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Amount') ?></th>
                            <th><?= __('Paid') ?></th>
                            <th><?= __('Title Id') ?></th>
                            <th><?= __('Title Other') ?></th>
                            <th><?= __('First Name') ?></th>
                            <th><?= __('Surname') ?></th>
                            <th><?= __('Address 1') ?></th>
                            <th><?= __('Address 2') ?></th>
                            <th><?= __('City') ?></th>
                            <th><?= __('County') ?></th>
                            <th><?= __('Postal Code') ?></th>
                            <th><?= __('Country Id') ?></th>
                            <th><?= __('Email') ?></th>
                            <th><?= __('Email Confirm') ?></th>
                            <th><?= __('Telephone') ?></th>
                            <th><?= __('Mobile Phone') ?></th>
                            <th><?= __('D Title Id') ?></th>
                            <th><?= __('D Title Other') ?></th>
                            <th><?= __('D First Name') ?></th>
                            <th><?= __('D Surname') ?></th>
                            <th><?= __('D Address 1') ?></th>
                            <th><?= __('D Address 2') ?></th>
                            <th><?= __('D City') ?></th>
                            <th><?= __('D County') ?></th>
                            <th><?= __('D Postal Code') ?></th>
                            <th><?= __('No Email') ?></th>
                            <th><?= __('No Telephone') ?></th>
                            <th><?= __('No Letter') ?></th>
                            <th><?= __('Optin Email') ?></th>
                            <th><?= __('Optin Telephone') ?></th>
                            <th><?= __('Optin Letter') ?></th>
                            <th><?= __('Created') ?></th>
                            <th><?= __('Modified') ?></th>
                            <th><?= __('Tx Status') ?></th>
                            <th><?= __('Tx Status Detail') ?></th>
                            <th><?= __('Tx Code') ?></th>
                            <th><?= __('Tx Sagepay Id') ?></th>
                            <th><?= __('Tx Cardtype') ?></th>
                            <th><?= __('Tx Card Lastdigits') ?></th>
                            <th><?= __('Is Mail Sent') ?></th>
                            <th><?= __('Decline Code') ?></th>
                            <th><?= __('Expiry Date') ?></th>
                            <th><?= __('Bank Auth Code') ?></th>
                            <th><?= __('D Country Id') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($country->orders as $orders) : ?>
                        <tr>
                            <td><?= h($orders->id) ?></td>
                            <td><?= h($orders->amount) ?></td>
                            <td><?= h($orders->paid) ?></td>
                            <td><?= h($orders->title_id) ?></td>
                            <td><?= h($orders->title_other) ?></td>
                            <td><?= h($orders->first_name) ?></td>
                            <td><?= h($orders->surname) ?></td>
                            <td><?= h($orders->address_1) ?></td>
                            <td><?= h($orders->address_2) ?></td>
                            <td><?= h($orders->city) ?></td>
                            <td><?= h($orders->county) ?></td>
                            <td><?= h($orders->postal_code) ?></td>
                            <td><?= h($orders->country_id) ?></td>
                            <td><?= h($orders->email) ?></td>
                            <td><?= h($orders->email_confirm) ?></td>
                            <td><?= h($orders->telephone) ?></td>
                            <td><?= h($orders->mobile_phone) ?></td>
                            <td><?= h($orders->d_title_id) ?></td>
                            <td><?= h($orders->d_title_other) ?></td>
                            <td><?= h($orders->d_first_name) ?></td>
                            <td><?= h($orders->d_surname) ?></td>
                            <td><?= h($orders->d_address_1) ?></td>
                            <td><?= h($orders->d_address_2) ?></td>
                            <td><?= h($orders->d_city) ?></td>
                            <td><?= h($orders->d_county) ?></td>
                            <td><?= h($orders->d_postal_code) ?></td>
                            <td><?= h($orders->no_email) ?></td>
                            <td><?= h($orders->no_telephone) ?></td>
                            <td><?= h($orders->no_letter) ?></td>
                            <td><?= h($orders->optin_email) ?></td>
                            <td><?= h($orders->optin_telephone) ?></td>
                            <td><?= h($orders->optin_letter) ?></td>
                            <td><?= h($orders->created) ?></td>
                            <td><?= h($orders->modified) ?></td>
                            <td><?= h($orders->tx_status) ?></td>
                            <td><?= h($orders->tx_status_detail) ?></td>
                            <td><?= h($orders->tx_code) ?></td>
                            <td><?= h($orders->tx_sagepay_id) ?></td>
                            <td><?= h($orders->tx_cardtype) ?></td>
                            <td><?= h($orders->tx_card_lastdigits) ?></td>
                            <td><?= h($orders->is_mail_sent) ?></td>
                            <td><?= h($orders->decline_code) ?></td>
                            <td><?= h($orders->expiry_date) ?></td>
                            <td><?= h($orders->bank_auth_code) ?></td>
                            <td><?= h($orders->d_country_id) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Orders', 'action' => 'view', $orders->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Orders', 'action' => 'edit', $orders->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Orders', 'action' => 'delete', $orders->id], ['confirm' => __('Are you sure you want to delete # {0}?', $orders->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            <div class="related">
                <h4><?= __('Related Registrations') ?></h4>
                <?php if (!empty($country->registrations)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Amount') ?></th>
                            <th><?= __('Age On Race') ?></th>
                            <th><?= __('Date Of Birth') ?></th>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Title Id') ?></th>
                            <th><?= __('Title Other') ?></th>
                            <th><?= __('First Name') ?></th>
                            <th><?= __('Surname') ?></th>
                            <th><?= __('Address 1') ?></th>
                            <th><?= __('Address 2') ?></th>
                            <th><?= __('City') ?></th>
                            <th><?= __('County') ?></th>
                            <th><?= __('Postal Code') ?></th>
                            <th><?= __('Country Id') ?></th>
                            <th><?= __('Email') ?></th>
                            <th><?= __('Email Confirm') ?></th>
                            <th><?= __('Telephone') ?></th>
                            <th><?= __('Mobile') ?></th>
                            <th><?= __('Emergency Contact') ?></th>
                            <th><?= __('Emergency Contact Number') ?></th>
                            <th><?= __('Medical Conditions') ?></th>
                            <th><?= __('Disclaimer') ?></th>
                            <th><?= __('Tx Status') ?></th>
                            <th><?= __('Tx Status Detail') ?></th>
                            <th><?= __('Tx Code') ?></th>
                            <th><?= __('Tx Sagepay Id') ?></th>
                            <th><?= __('Tx Cardtype') ?></th>
                            <th><?= __('Tx Card Lastdigits') ?></th>
                            <th><?= __('Is Mail Sent') ?></th>
                            <th><?= __('Decline Code') ?></th>
                            <th><?= __('Expiry Date') ?></th>
                            <th><?= __('Bank Auth Code') ?></th>
                            <th><?= __('Created') ?></th>
                            <th><?= __('Modified') ?></th>
                            <th><?= __('Event Id') ?></th>
                            <th><?= __('Event Cost Id') ?></th>
                            <th><?= __('Custom Field 1') ?></th>
                            <th><?= __('Custom Field 2') ?></th>
                            <th><?= __('Organisation') ?></th>
                            <th><?= __('No Email') ?></th>
                            <th><?= __('No Telephone') ?></th>
                            <th><?= __('No Letter') ?></th>
                            <th><?= __('Optin Email') ?></th>
                            <th><?= __('Optin Telephone') ?></th>
                            <th><?= __('Optin Letter') ?></th>
                            <th><?= __('Additional Guests') ?></th>
                            <th><?= __('Heard About') ?></th>
                            <th><?= __('Heard About Other') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($country->registrations as $registrations) : ?>
                        <tr>
                            <td><?= h($registrations->amount) ?></td>
                            <td><?= h($registrations->age_on_race) ?></td>
                            <td><?= h($registrations->date_of_birth) ?></td>
                            <td><?= h($registrations->id) ?></td>
                            <td><?= h($registrations->title_id) ?></td>
                            <td><?= h($registrations->title_other) ?></td>
                            <td><?= h($registrations->first_name) ?></td>
                            <td><?= h($registrations->surname) ?></td>
                            <td><?= h($registrations->address_1) ?></td>
                            <td><?= h($registrations->address_2) ?></td>
                            <td><?= h($registrations->city) ?></td>
                            <td><?= h($registrations->county) ?></td>
                            <td><?= h($registrations->postal_code) ?></td>
                            <td><?= h($registrations->country_id) ?></td>
                            <td><?= h($registrations->email) ?></td>
                            <td><?= h($registrations->email_confirm) ?></td>
                            <td><?= h($registrations->telephone) ?></td>
                            <td><?= h($registrations->mobile) ?></td>
                            <td><?= h($registrations->emergency_contact) ?></td>
                            <td><?= h($registrations->emergency_contact_number) ?></td>
                            <td><?= h($registrations->medical_conditions) ?></td>
                            <td><?= h($registrations->disclaimer) ?></td>
                            <td><?= h($registrations->tx_status) ?></td>
                            <td><?= h($registrations->tx_status_detail) ?></td>
                            <td><?= h($registrations->tx_code) ?></td>
                            <td><?= h($registrations->tx_sagepay_id) ?></td>
                            <td><?= h($registrations->tx_cardtype) ?></td>
                            <td><?= h($registrations->tx_card_lastdigits) ?></td>
                            <td><?= h($registrations->is_mail_sent) ?></td>
                            <td><?= h($registrations->decline_code) ?></td>
                            <td><?= h($registrations->expiry_date) ?></td>
                            <td><?= h($registrations->bank_auth_code) ?></td>
                            <td><?= h($registrations->created) ?></td>
                            <td><?= h($registrations->modified) ?></td>
                            <td><?= h($registrations->event_id) ?></td>
                            <td><?= h($registrations->event_cost_id) ?></td>
                            <td><?= h($registrations->custom_field_1) ?></td>
                            <td><?= h($registrations->custom_field_2) ?></td>
                            <td><?= h($registrations->organisation) ?></td>
                            <td><?= h($registrations->no_email) ?></td>
                            <td><?= h($registrations->no_telephone) ?></td>
                            <td><?= h($registrations->no_letter) ?></td>
                            <td><?= h($registrations->optin_email) ?></td>
                            <td><?= h($registrations->optin_telephone) ?></td>
                            <td><?= h($registrations->optin_letter) ?></td>
                            <td><?= h($registrations->additional_guests) ?></td>
                            <td><?= h($registrations->heard_about) ?></td>
                            <td><?= h($registrations->heard_about_other) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Registrations', 'action' => 'view', $registrations->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Registrations', 'action' => 'edit', $registrations->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Registrations', 'action' => 'delete', $registrations->id], ['confirm' => __('Are you sure you want to delete # {0}?', $registrations->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
