<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Car $car
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Car'), ['action' => 'edit', $car->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Car'), ['action' => 'delete', $car->id], ['confirm' => __('Are you sure you want to delete # {0}?', $car->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Cars'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="cars view content">
            <h3>Edit car registration</h3>
            <table>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($car->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Team Name') ?></th>
                    <td><?= h($car->team_name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Team Number') ?></th>
                    <td><?= $this->Number->format($car->team_number) ?></td>
                </tr>
                <tr>
                    <th><?= __('Payment') ?></th>
                    <td><?= h($car->payment) ?></td>
                </tr>
                <tr>
                    <th><?= __('Car Theme') ?></th>
                    <td><?= h($car->car_theme) ?></td>
                </tr>
                <tr>
                    <th><?= __('Contact Mobile') ?></th>
                    <td><?= h($car->contact_mobile) ?></td>
                </tr>
                <tr>
                    <th><?= __('Heard About') ?></th>
                    <td><?= h($car->heard_about) ?></td>
                </tr>
                <tr>
                    <th><?= __('Heard About Other') ?></th>
                    <td><?= h($car->heard_about_other) ?></td>
                </tr>
                <tr>
                    <th><?= __('Created') ?></th>
                    <td><?= h($car->created) ?></td>
                </tr>
                <tr>
                    <th><?= __('Modified') ?></th>
                    <td><?= h($car->modified) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tcs1') ?></th>
                    <td><?= $car->tcs1 ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Tcs2') ?></th>
                    <td><?= $car->tcs2 ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Tcs3') ?></th>
                    <td><?= $car->tcs3 ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Tcs4') ?></th>
                    <td><?= $car->tcs4 ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Is Mail Sent') ?></th>
                    <td><?= $car->is_mail_sent ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Paid') ?></th>
                    <td><?= $car->paid ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Agree1') ?></th>
                    <td><?= $car->agree1 ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Agree2') ?></th>
                    <td><?= $car->agree2 ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Agree3') ?></th>
                    <td><?= $car->agree3 ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Agree4') ?></th>
                    <td><?= $car->agree4 ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Agree5') ?></th>
                    <td><?= $car->agree5 ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Agree6') ?></th>
                    <td><?= $car->agree6 ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Agree7') ?></th>
                    <td><?= $car->agree7 ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Card Lastdigits') ?></th>
                    <td><?= $this->Number->format($car->tx_card_lastdigits) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Status') ?></th>
                    <td><?= h($car->tx_status) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Status Detail') ?></th>
                    <td><?= h($car->tx_status_detail) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Code') ?></th>
                    <td><?= h($car->tx_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Sagepay Id') ?></th>
                    <td><?= h($car->tx_sagepay_id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tx Cardtype') ?></th>
                    <td><?= h($car->tx_cardtype) ?></td>
                </tr>
                <tr>
                    <th><?= __('Decline Code') ?></th>
                    <td><?= h($car->decline_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Expiry Date') ?></th>
                    <td><?= h($car->expiry_date) ?></td>
                </tr>
                <tr>
                    <th><?= __('Bank Auth Code') ?></th>
                    <td><?= h($car->bank_auth_code) ?></td>
                </tr>

            </table>
            <div class="related">
                <h4><?= __('Related Car Participants') ?></h4>
                <?php if (!empty($car->car_parts)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('First Name') ?></th>
                            <th><?= __('Surname') ?></th>
                            <th><?= __('Organisation') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($car->car_parts as $carParts) : ?>
                        <tr>
                            <td><?= h($carParts->id) ?></td>
                            <td><?= h($carParts->first_name) ?></td>
                            <td><?= h($carParts->surname) ?></td>
                            <td><?= h($carParts->organisation) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'CarParts', 'action' => 'view', $carParts->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'CarParts', 'action' => 'edit', $carParts->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'CarParts', 'action' => 'delete', $carParts->id], ['confirm' => __('Are you sure you want to delete # {0}?', $carParts->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
