<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\CarSetting> $carSettings
 */
?>
<div class="carSettings index content">
    <?= $this->Html->link(__('New Car Setting'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Car Settings') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('event_name') ?></th>
                    <th><?= $this->Paginator->sort('event_year') ?></th>
                    <th><?= $this->Paginator->sort('event_logo') ?></th>
                    <th><?= $this->Paginator->sort('registration_fee') ?></th>
                    <th><?= $this->Paginator->sort('minimum_sponsorship') ?></th>
                    <th><?= $this->Paginator->sort('interim_sponsorship') ?></th>
                    <th><?= $this->Paginator->sort('interim_fee_deadline') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($carSettings as $carSetting): ?>
                <tr>
                    <td><?= $this->Number->format($carSetting->id) ?></td>
                    <td><?= h($carSetting->event_name) ?></td>
                    <td><?= $carSetting->event_year === null ? '' : $this->Number->format($carSetting->event_year) ?></td>
                    <td><?= h($carSetting->event_logo) ?></td>
                    <td><?= $carSetting->registration_fee === null ? '' : $this->Number->format($carSetting->registration_fee) ?></td>
                    <td><?= $carSetting->minimum_sponsorship === null ? '' : $this->Number->format($carSetting->minimum_sponsorship) ?></td>
                    <td><?= $carSetting->interim_sponsorship === null ? '' : $this->Number->format($carSetting->interim_sponsorship) ?></td>
                    <td><?= h($carSetting->interim_fee_deadline) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $carSetting->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $carSetting->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $carSetting->id], ['confirm' => __('Are you sure you want to delete # {0}?', $carSetting->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
