<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\CarSetting $carSetting
 */
?>
<div class="row">
    <div class="column column-80">
        <div class="carSettings form content">
            <?= $this->Form->create($carSetting, ['enctype' => 'multipart/form-data']) ?>
            <fieldset>
                <h3><?= __('Car Settings') ?></h3>
                <?php
                echo $this->Form->control('event_name');
                echo $this->Form->control('event_year');
                echo $this->Form->control('event_blurb');
                ?>
                <label>Current logo:</label>
                <?php echo $this->Html->image('cars/' . $carSetting->event_logo, [
                    'width' => '100',
                ]); ?>
                <?php
                echo $this->Form->control('upload', ['type' => 'file', 'label' => 'Event logo']);
                echo $this->Form->control('registration_fee');
                echo $this->Form->control('minimum_sponsorship');
                echo $this->Form->control('interim_sponsorship');
                echo $this->Form->control('interim_fee_deadline', ['empty' => true]);
                echo $this->Form->control('last_checkbox_text');
                echo $this->Form->control('terms_conditions_text');
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>