<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\CarPart $carPart
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Car Part'), ['action' => 'edit', $carPart->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Car Part'), ['action' => 'delete', $carPart->id], ['confirm' => __('Are you sure you want to delete # {0}?', $carPart->id), 'class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="carParts view content">
            <h3><?= h($carPart->title_other) ?></h3>
            <table>
                <tr>
                    <th><?= __('Car') ?></th>
                    <td><?= $carPart->hasValue('car') ? $this->Html->link($carPart->car->team_name, ['controller' => 'Cars', 'action' => 'view', $carPart->car->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Title') ?></th>
                    <td><?= h($carPart->title->name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Title Other') ?></th>
                    <td><?= h($carPart->title_other) ?></td>
                </tr>
                <tr>
                    <th><?= __('First Name') ?></th>
                    <td><?= h($carPart->first_name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Surname') ?></th>
                    <td><?= h($carPart->surname) ?></td>
                </tr>
                <tr>
                    <th><?= __('Organisation') ?></th>
                    <td><?= h($carPart->organisation) ?></td>
                </tr>
                <tr>
                    <th><?= __('Address 1') ?></th>
                    <td><?= h($carPart->address_1) ?></td>
                </tr>
                <tr>
                    <th><?= __('Address 2') ?></th>
                    <td><?= h($carPart->address_2) ?></td>
                </tr>
                <tr>
                    <th><?= __('City') ?></th>
                    <td><?= h($carPart->city) ?></td>
                </tr>
                <tr>
                    <th><?= __('County') ?></th>
                    <td><?= h($carPart->county) ?></td>
                </tr>
                <tr>
                    <th><?= __('Postal Code') ?></th>
                    <td><?= h($carPart->postal_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Country') ?></th>
                    <td><?= $carPart->hasValue('country') ? $this->Html->link($carPart->country->name, ['controller' => 'Countries', 'action' => 'view', $carPart->country->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('State Code') ?></th>
                    <td><?= h($carPart->state_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Email') ?></th>
                    <td><?= h($carPart->email) ?></td>
                </tr>
                <tr>
                    <th><?= __('Email Confirm') ?></th>
                    <td><?= h($carPart->email_confirm) ?></td>
                </tr>
                <tr>
                    <th><?= __('Telephone') ?></th>
                    <td><?= h($carPart->telephone) ?></td>
                </tr>
                <tr>
                    <th><?= __('Mobile Phone') ?></th>
                    <td><?= h($carPart->mobile_phone) ?></td>
                </tr>
                <tr>
                    <th><?= __('Dietary') ?></th>
                    <td><?= h($carPart->dietary) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($carPart->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Created') ?></th>
                    <td><?= h($carPart->created) ?></td>
                </tr>
                <tr>
                    <th><?= __('Modified') ?></th>
                    <td><?= h($carPart->modified) ?></td>
                </tr>
                <tr>
                    <th><?= __('Date Of Birth') ?></th>
                    <td><?= h($carPart->date_of_birth) ?></td>
                </tr>
                <tr>
                    <th><?= __('No Email') ?></th>
                    <td><?= $carPart->no_email ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('No Telephone') ?></th>
                    <td><?= $carPart->no_telephone ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('No Letter') ?></th>
                    <td><?= $carPart->no_letter ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Optin Email') ?></th>
                    <td><?= $carPart->optin_email ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Optin Telephone') ?></th>
                    <td><?= $carPart->optin_telephone ? __('Yes') : __('No'); ?></td>
                </tr>
                <tr>
                    <th><?= __('Optin Letter') ?></th>
                    <td><?= $carPart->optin_letter ? __('Yes') : __('No'); ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
