<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Amount> $amounts
 */
?>
<div class="amounts index content">
    <?= $this->Html->link(__('New Amount'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Donation Amounts') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('amount') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($amounts as $amount): ?>
                <tr>
                    <td><?= $this->Number->format($amount->id) ?></td>
                    <td><?= $this->Number->format($amount->amount) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $amount->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $amount->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $amount->id], ['confirm' => __('Are you sure you want to delete # {0}?', $amount->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
