<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * GolfSettings Model
 *
 * @method \App\Model\Entity\GolfSetting newEmptyEntity()
 * @method \App\Model\Entity\GolfSetting newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\GolfSetting[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\GolfSetting get($primaryKey, $options = [])
 * @method \App\Model\Entity\GolfSetting findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\GolfSetting patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\GolfSetting[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\GolfSetting|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\GolfSetting saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\GolfSetting[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\GolfSetting[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\GolfSetting[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\GolfSetting[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class GolfSettingsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('golf_settings');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('blurb_top')
            ->allowEmptyString('blurb_top');

        return $validator;
    }
}
