<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * GolfPlayers Model
 *
 * @property \App\Model\Table\GolfsTable&\Cake\ORM\Association\BelongsTo $Golfs
 * @property \App\Model\Table\TitlesTable&\Cake\ORM\Association\BelongsTo $Titles
 * @property \App\Model\Table\CountriesTable&\Cake\ORM\Association\BelongsTo $Countries
 *
 * @method \App\Model\Entity\GolfPlayer newEmptyEntity()
 * @method \App\Model\Entity\GolfPlayer newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\GolfPlayer[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\GolfPlayer get($primaryKey, $options = [])
 * @method \App\Model\Entity\GolfPlayer findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\GolfPlayer patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\GolfPlayer[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\GolfPlayer|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\GolfPlayer saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\GolfPlayer[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\GolfPlayer[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\GolfPlayer[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\GolfPlayer[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class GolfPlayersTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('golf_players');
        $this->setDisplayField('title_other');
        $this->setPrimaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Golfs', [
            'foreignKey' => 'golf_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Titles', [
            'foreignKey' => 'title_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Countries', [
            'foreignKey' => 'country_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator->integer('golf_id')->notEmptyString('golf_id');

        $validator->integer('title_id')->notEmptyString('title_id');

        $validator
            ->scalar('first_name')
            ->maxLength('first_name', 255)
            ->requirePresence('first_name', 'create')
            ->notEmptyString('first_name');

        $validator
            ->scalar('surname')
            ->maxLength('surname', 255)
            ->requirePresence('surname', 'create')
            ->notEmptyString('surname');

        $validator
            ->scalar('address_1')
            ->maxLength('address_1', 255)
            ->requirePresence('address_1', 'create')
            ->notEmptyString('address_1');

        $validator
            ->scalar('city')
            ->maxLength('city', 255)
            ->requirePresence('city', 'create')
            ->notEmptyString('city');

        $validator
            ->scalar('county')
            ->maxLength('county', 255)
            ->requirePresence('county', 'create')
            ->notEmptyString('county');

        $validator
            ->scalar('postal_code')
            ->maxLength('postal_code', 255)
            ->requirePresence('postal_code', 'create')
            ->notEmptyString('postal_code');

        $validator->integer('country_id')->notEmptyString('country_id');

        $validator
            ->email('email')
            ->requirePresence('email', 'create')
            ->notEmptyString('email');

        $validator
            ->scalar('email_confirm')
            ->maxLength('email_confirm', 255)
            ->requirePresence('email_confirm', 'create')
            ->notEmptyString('email_confirm');

        $validator->add('email_confirm', 'compareWith', [
            'rule' => ['compareWith', 'email'],
            'message' => 'Email addresses do not match',
        ]);

        $validator
            ->scalar('telephone')
            ->maxLength('telephone', 255)
            ->requirePresence('telephone', 'create')
            ->notEmptyString('telephone');

        $validator
            ->scalar('dietary_requirements')
            ->requirePresence('dietary_requirements', 'create')
            ->notEmptyString('dietary_requirements');

        $validator->boolean('no_email')->notEmptyString('no_email');

        $validator->boolean('no_telephone')->notEmptyString('no_telephone');

        $validator->boolean('no_letter')->notEmptyString('no_letter');

        $validator->boolean('optin_email')->notEmptyString('optin_email');

        $validator->boolean('optin_telephone')->notEmptyString('optin_telephone');

        $validator->boolean('optin_letter')->notEmptyString('optin_letter');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn('golf_id', 'Golfs'), ['errorField' => 'golf_id']);
        $rules->add($rules->existsIn('title_id', 'Titles'), ['errorField' => 'title_id']);
        $rules->add($rules->existsIn('country_id', 'Countries'), ['errorField' => 'country_id']);

        return $rules;
    }
}
