<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * CarSettings Model
 *
 * @method \App\Model\Entity\CarSetting newEmptyEntity()
 * @method \App\Model\Entity\CarSetting newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\CarSetting[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\CarSetting get($primaryKey, $options = [])
 * @method \App\Model\Entity\CarSetting findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\CarSetting patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\CarSetting[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\CarSetting|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\CarSetting saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\CarSetting[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\CarSetting[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\CarSetting[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\CarSetting[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class CarSettingsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('car_settings');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('event_name')
            ->maxLength('event_name', 300)
            ->allowEmptyString('event_name');

        $validator
            ->integer('event_year')
            ->allowEmptyString('event_year');

        $validator
            ->scalar('event_blurb')
            ->allowEmptyString('event_blurb');

        $validator
            ->scalar('event_logo')
            ->maxLength('event_logo', 100)
            ->allowEmptyString('event_logo');

        $validator
            ->integer('registration_fee')
            ->allowEmptyString('registration_fee');

        $validator
            ->integer('minimum_sponsorship')
            ->allowEmptyString('minimum_sponsorship');

        $validator
            ->integer('interim_sponsorship')
            ->allowEmptyString('interim_sponsorship');

        $validator
            ->date('interim_fee_deadline')
            ->allowEmptyDate('interim_fee_deadline');

        $validator
            ->scalar('last_checkbox_text')
            ->allowEmptyString('last_checkbox_text');

        $validator
            ->scalar('terms_conditions_text')
            ->allowEmptyString('terms_conditions_text');

        return $validator;
    }
}
