<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Title Entity
 *
 * @property int $id
 * @property string $name
 *
 * @property \App\Model\Entity\CarPart[] $car_parts
 * @property \App\Model\Entity\Donation[] $donations
 * @property \App\Model\Entity\GolfPlayer[] $golf_players
 * @property \App\Model\Entity\Light[] $lights
 * @property \App\Model\Entity\Order[] $orders
 * @property \App\Model\Entity\Registration[] $registrations
 */
class Title extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'name' => true,
        'car_parts' => true,
        'donations' => true,
        'golf_players' => true,
        'lights' => true,
        'orders' => true,
        'registrations' => true,
    ];
}
