<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Registration Entity
 *
 * @property float $amount
 * @property string $age_on_race
 * @property \Cake\I18n\Date|null $date_of_birth
 * @property int $id
 * @property int $title_id
 * @property string $title_other
 * @property string $first_name
 * @property string $surname
 * @property string $address_1
 * @property string $address_2
 * @property string $city
 * @property string $county
 * @property string $postal_code
 * @property int $country_id
 * @property string $email
 * @property string $email_confirm
 * @property string $telephone
 * @property string $mobile
 * @property string $emergency_contact
 * @property string $emergency_contact_number
 * @property string|null $medical_conditions
 * @property bool $disclaimer
 * @property string $tx_status
 * @property string $tx_status_detail
 * @property string $tx_code
 * @property string $tx_sagepay_id
 * @property string $tx_cardtype
 * @property int $tx_card_lastdigits
 * @property bool $is_mail_sent
 * @property string|null $decline_code
 * @property string|null $expiry_date
 * @property string|null $bank_auth_code
 * @property \Cake\I18n\DateTime $created
 * @property \Cake\I18n\DateTime $modified
 * @property int $event_id
 * @property int|null $event_cost_id
 * @property string $custom_field_1
 * @property string $custom_field_2
 * @property string $organisation
 * @property bool $no_email
 * @property bool $no_telephone
 * @property bool $no_letter
 * @property bool $optin_email
 * @property bool $optin_telephone
 * @property bool $optin_letter
 * @property string|null $additional_guests
 * @property string $heard_about
 * @property string $heard_about_other
 *
 * @property \App\Model\Entity\Title $title
 * @property \App\Model\Entity\Country $country
 * @property \App\Model\Entity\Event $event
 * @property \App\Model\Entity\EventCost $event_cost
 * @property \App\Model\Entity\Ticket[] $tickets
 */
class Registration extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'amount' => true,
        'age_on_race' => true,
        'date_of_birth' => true,
        'title_id' => true,
        'title_other' => true,
        'first_name' => true,
        'surname' => true,
        'address_1' => true,
        'address_2' => true,
        'city' => true,
        'county' => true,
        'postal_code' => true,
        'country_id' => true,
        'email' => true,
        'email_confirm' => true,
        'telephone' => true,
        'mobile' => true,
        'emergency_contact' => true,
        'emergency_contact_number' => true,
        'medical_conditions' => true,
        'disclaimer' => true,
        'tx_status' => true,
        'tx_status_detail' => true,
        'tx_code' => true,
        'tx_sagepay_id' => true,
        'tx_cardtype' => true,
        'tx_card_lastdigits' => true,
        'is_mail_sent' => true,
        'decline_code' => true,
        'expiry_date' => true,
        'bank_auth_code' => true,
        'created' => true,
        'modified' => true,
        'event_id' => true,
        'event_cost_id' => true,
        'custom_field_1' => true,
        'custom_field_2' => true,
        'organisation' => true,
        'no_email' => true,
        'no_telephone' => true,
        'no_letter' => true,
        'optin_email' => true,
        'optin_telephone' => true,
        'optin_letter' => true,
        'additional_guests' => true,
        'heard_about' => true,
        'heard_about_other' => true,
        'title' => true,
        'country' => true,
        'event' => true,
        'event_cost' => true,
        'tickets' => true,
    ];

    public function grandTotal(): float
    {
        $total = 0;
        foreach ($this->tickets as $ticket) {
            $total += $ticket->amount * $ticket->event_cost->price;
        }

        return $total;
    }
}
