<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;
use Cake\Core\Configure;

/**
 * Order Entity
 *
 * @property int $id
 * @property string $amount
 * @property bool $paid
 * @property int $title_id
 * @property string $title_other
 * @property string $first_name
 * @property string $surname
 * @property string $address_1
 * @property string $address_2
 * @property string $city
 * @property string $county
 * @property string $postal_code
 * @property int $country_id
 * @property string $email
 * @property string $email_confirm
 * @property string $telephone
 * @property string $mobile_phone
 * @property int $d_title_id
 * @property string $d_title_other
 * @property string $d_first_name
 * @property string $d_surname
 * @property string $d_address_1
 * @property string $d_address_2
 * @property string $d_city
 * @property string $d_county
 * @property string $d_postal_code
 * @property bool $no_email
 * @property bool $no_telephone
 * @property bool $no_letter
 * @property bool $optin_email
 * @property bool $optin_telephone
 * @property bool $optin_letter
 * @property \Cake\I18n\DateTime $created
 * @property \Cake\I18n\DateTime $modified
 * @property string $tx_status
 * @property string $tx_status_detail
 * @property string $tx_code
 * @property string $tx_sagepay_id
 * @property string $tx_cardtype
 * @property int $tx_card_lastdigits
 * @property bool $is_mail_sent
 * @property string|null $decline_code
 * @property string|null $expiry_date
 * @property string|null $bank_auth_code
 * @property int $d_country_id
 *
 * @property \App\Model\Entity\Title $title
 * @property \App\Model\Entity\Country $country
 * @property \App\Model\Entity\OrderItem[] $order_items
 */
class Order extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'amount' => true,
        'paid' => true,
        'title_id' => true,
        'title_other' => true,
        'first_name' => true,
        'surname' => true,
        'address_1' => true,
        'address_2' => true,
        'city' => true,
        'county' => true,
        'postal_code' => true,
        'country_id' => true,
        'email' => true,
        'email_confirm' => true,
        'telephone' => true,
        'mobile_phone' => true,
        'd_title_id' => true,
        'd_title_other' => true,
        'd_first_name' => true,
        'd_surname' => true,
        'd_address_1' => true,
        'd_address_2' => true,
        'd_city' => true,
        'd_county' => true,
        'd_postal_code' => true,
        'no_email' => true,
        'no_telephone' => true,
        'no_letter' => true,
        'optin_email' => true,
        'optin_telephone' => true,
        'optin_letter' => true,
        'created' => true,
        'modified' => true,
        'tx_status' => true,
        'tx_status_detail' => true,
        'tx_code' => true,
        'tx_sagepay_id' => true,
        'tx_cardtype' => true,
        'tx_card_lastdigits' => true,
        'is_mail_sent' => true,
        'decline_code' => true,
        'expiry_date' => true,
        'bank_auth_code' => true,
        'd_country_id' => true,
        'title' => true,
        'country' => true,
        'order_items' => true,
    ];

    function orderTotal()
    {
        $total = 0;
        foreach ($this->order_items as $item) {
            $total += $item->price * $item->quantity;
        }
        return $total;
    }

    function deliveryTotal()
    {
        Configure::load('payments');
        return Configure::read('Forms.Orders.delivery_charge');
    }

    function grandTotal()
    {
        return $this->orderTotal() + $this->deliveryTotal();
    }
}
