<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Light Entity
 *
 * @property int $id
 * @property string $donation_amount
 * @property string $message
 * @property string $homes
 * @property string|null $gift_aid_for
 * @property bool $gift_aid_understood
 * @property int $title_id
 * @property string $title_other
 * @property string $first_name
 * @property string $surname
 * @property string $address_1
 * @property string $address_2
 * @property string $city
 * @property string $county
 * @property string $postal_code
 * @property int $country_id
 * @property string $state_code
 * @property string $email
 * @property string $email_confirm
 * @property string $telephone
 * @property string $mobile_phone
 * @property bool $no_email
 * @property bool $no_telephone
 * @property bool $no_letter
 * @property bool $optin_email
 * @property bool $optin_telephone
 * @property bool $optin_letter
 * @property string $tx_status
 * @property string $tx_status_detail
 * @property string $tx_code
 * @property string $tx_sagepay_id
 * @property string $tx_cardtype
 * @property int $tx_card_lastdigits
 * @property bool $is_mail_sent
 * @property string|null $decline_code
 * @property string|null $expiry_date
 * @property string|null $bank_auth_code
 * @property \Cake\I18n\DateTime $created
 * @property \Cake\I18n\DateTime $modified
 *
 * @property \App\Model\Entity\Title $title
 * @property \App\Model\Entity\Country $country
 */
class Light extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'donation_amount' => true,
        'message' => true,
        'homes' => true,
        'gift_aid_for' => true,
        'gift_aid_understood' => true,
        'title_id' => true,
        'title_other' => true,
        'first_name' => true,
        'surname' => true,
        'address_1' => true,
        'address_2' => true,
        'city' => true,
        'county' => true,
        'postal_code' => true,
        'country_id' => true,
        'state_code' => true,
        'email' => true,
        'email_confirm' => true,
        'telephone' => true,
        'mobile_phone' => true,
        'no_email' => true,
        'no_telephone' => true,
        'no_letter' => true,
        'optin_email' => true,
        'optin_telephone' => true,
        'optin_letter' => true,
        'tx_status' => true,
        'tx_status_detail' => true,
        'tx_code' => true,
        'tx_sagepay_id' => true,
        'tx_cardtype' => true,
        'tx_card_lastdigits' => true,
        'is_mail_sent' => true,
        'decline_code' => true,
        'expiry_date' => true,
        'bank_auth_code' => true,
        'created' => true,
        'modified' => true,
        'title' => true,
        'country' => true,
    ];
}
