<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * GolfPlayer Entity
 *
 * @property int $id
 * @property int $golf_id
 * @property int $title_id
 * @property string $title_other
 * @property string $first_name
 * @property string $surname
 * @property string $organisation
 * @property string $address_1
 * @property string $address_2
 * @property string $city
 * @property string $county
 * @property string $postal_code
 * @property int $country_id
 * @property string $state_code
 * @property string $email
 * @property string $email_confirm
 * @property string $telephone
 * @property string $mobile_phone
 * @property string $dietary_requirements
 * @property bool $no_email
 * @property bool $no_telephone
 * @property bool $no_letter
 * @property bool $optin_email
 * @property bool $optin_telephone
 * @property bool $optin_letter
 * @property \Cake\I18n\DateTime $created
 * @property \Cake\I18n\DateTime $modified
 *
 * @property \App\Model\Entity\Golf $golf
 * @property \App\Model\Entity\Title $title
 * @property \App\Model\Entity\Country $country
 */
class GolfPlayer extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'golf_id' => true,
        'title_id' => true,
        'title_other' => true,
        'first_name' => true,
        'surname' => true,
        'organisation' => true,
        'address_1' => true,
        'address_2' => true,
        'city' => true,
        'county' => true,
        'postal_code' => true,
        'country_id' => true,
        'state_code' => true,
        'email' => true,
        'email_confirm' => true,
        'telephone' => true,
        'mobile_phone' => true,
        'dietary_requirements' => true,
        'no_email' => true,
        'no_telephone' => true,
        'no_letter' => true,
        'optin_email' => true,
        'optin_telephone' => true,
        'optin_letter' => true,
        'created' => true,
        'modified' => true,
        'golf' => true,
        'title' => true,
        'country' => true,
    ];

    public function fullName()
    {
        return $this->first_name . ' ' . $this->surname;
    }
}
