<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Event Entity
 *
 * @property int $id
 * @property string $name
 * @property \Cake\I18n\Date $event_date
 * @property bool $participation_reasons_on
 * @property bool $emergency_contact_on
 * @property string $custom_field_1
 * @property string $custom_field_2
 * @property string $email_text
 * @property bool $active
 * @property bool $multiple_tickets
 * @property bool $dob_on
 * @property string $dob_text
 * @property bool $terms_on
 * @property string $terms_text
 *
 * @property \App\Model\Entity\EventCost[] $event_costs
 * @property \App\Model\Entity\Registration[] $registrations
 */
class Event extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'name' => true,
        'event_date' => true,
        'participation_reasons_on' => true,
        'emergency_contact_on' => true,
        'custom_field_1' => true,
        'custom_field_2' => true,
        'email_text' => true,
        'active' => true,
        'multiple_tickets' => true,
        'dob_on' => true,
        'dob_text' => true,
        'terms_on' => true,
        'terms_text' => true,
        'event_costs' => true,
        'registrations' => true,
    ];
}
