<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * CarSetting Entity
 *
 * @property int $id
 * @property string|null $event_name
 * @property int|null $event_year
 * @property string|null $event_blurb
 * @property string|null $event_logo
 * @property int|null $registration_fee
 * @property int|null $minimum_sponsorship
 * @property int|null $interim_sponsorship
 * @property \Cake\I18n\Date|null $interim_fee_deadline
 * @property string|null $last_checkbox_text
 * @property string|null $terms_conditions_text
 */
class CarSetting extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'event_name' => true,
        'event_year' => true,
        'event_blurb' => true,
        'event_logo' => true,
        'registration_fee' => true,
        'minimum_sponsorship' => true,
        'interim_sponsorship' => true,
        'interim_fee_deadline' => true,
        'last_checkbox_text' => true,
        'terms_conditions_text' => true,
    ];
}
