<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Car Entity
 *
 * @property int $id
 * @property string $amount
 * @property string $payment
 * @property string $team_name
 * @property string $car_theme
 * @property int $team_number
 * @property string $contact_mobile
 * @property bool $tcs1
 * @property bool $tcs2
 * @property bool $tcs3
 * @property bool $tcs4
 * @property string $tx_status
 * @property string $tx_status_detail
 * @property string $tx_code
 * @property string $tx_sagepay_id
 * @property string $tx_cardtype
 * @property int $tx_card_lastdigits
 * @property bool $is_mail_sent
 * @property string|null $decline_code
 * @property string|null $expiry_date
 * @property string|null $bank_auth_code
 * @property \Cake\I18n\DateTime $created
 * @property \Cake\I18n\DateTime $modified
 * @property bool $paid
 * @property bool $agree1
 * @property bool $agree2
 * @property bool $agree3
 * @property bool $agree4
 * @property bool $agree5
 * @property bool $agree6
 * @property bool $agree7
 * @property string $heard_about
 * @property string $heard_about_other
 *
 * @property \App\Model\Entity\CarPart[] $car_parts
 */
class Car extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'amount' => true,
        'payment' => true,
        'team_name' => true,
        'car_theme' => true,
        'team_number' => true,
        'contact_mobile' => true,
        'tcs1' => true,
        'tcs2' => true,
        'tcs3' => true,
        'tcs4' => true,
        'tx_status' => true,
        'tx_status_detail' => true,
        'tx_code' => true,
        'tx_sagepay_id' => true,
        'tx_cardtype' => true,
        'tx_card_lastdigits' => true,
        'is_mail_sent' => true,
        'decline_code' => true,
        'expiry_date' => true,
        'bank_auth_code' => true,
        'created' => true,
        'modified' => true,
        'paid' => true,
        'agree1' => true,
        'agree2' => true,
        'agree3' => true,
        'agree4' => true,
        'agree5' => true,
        'agree6' => true,
        'agree7' => true,
        'heard_about' => true,
        'heard_about_other' => true,
        'car_parts' => true,
    ];
}
