<?php
declare(strict_types=1);

namespace App\Controller\Admin;

use App\Controller\AppController;

/**
 * Reasons Controller
 *
 * @property \App\Model\Table\ReasonsTable $Reasons
 */
class ReasonsController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $query = $this->Reasons->find();
        $reasons = $this->paginate($query);

        $this->set(compact('reasons'));
    }

    /**
     * View method
     *
     * @param string|null $id Reason id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $reason = $this->Reasons->get($id, contain: []);
        $this->set(compact('reason'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $reason = $this->Reasons->newEmptyEntity();
        if ($this->request->is('post')) {
            $reason = $this->Reasons->patchEntity($reason, $this->request->getData());
            if ($this->Reasons->save($reason)) {
                $this->Flash->success(__('The reason has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The reason could not be saved. Please, try again.'));
        }
        $this->set(compact('reason'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Reason id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $reason = $this->Reasons->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $reason = $this->Reasons->patchEntity($reason, $this->request->getData());
            if ($this->Reasons->save($reason)) {
                $this->Flash->success(__('The reason has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The reason could not be saved. Please, try again.'));
        }
        $this->set(compact('reason'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Reason id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $reason = $this->Reasons->get($id);
        if ($this->Reasons->delete($reason)) {
            $this->Flash->success(__('The reason has been deleted.'));
        } else {
            $this->Flash->error(__('The reason could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
