<?php
declare(strict_types=1);

namespace App\Controller\Admin;

use App\Controller\AppController;

/**
 * GolfTypes Controller
 *
 * @property \App\Model\Table\GolfTypesTable $GolfTypes
 */
class GolfTypesController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $query = $this->GolfTypes->find();
        $golfTypes = $this->paginate($query);

        $this->set(compact('golfTypes'));
    }

    /**
     * View method
     *
     * @param string|null $id Golf Type id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $golfType = $this->GolfTypes->get($id, contain: ['Golfs']);
        $this->set(compact('golfType'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $golfType = $this->GolfTypes->newEmptyEntity();
        if ($this->request->is('post')) {
            $golfType = $this->GolfTypes->patchEntity($golfType, $this->request->getData());
            if ($this->GolfTypes->save($golfType)) {
                $this->Flash->success(__('The golf type has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The golf type could not be saved. Please, try again.'));
        }
        $this->set(compact('golfType'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Golf Type id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $golfType = $this->GolfTypes->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $golfType = $this->GolfTypes->patchEntity($golfType, $this->request->getData());
            if ($this->GolfTypes->save($golfType)) {
                $this->Flash->success(__('The golf type has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The golf type could not be saved. Please, try again.'));
        }
        $this->set(compact('golfType'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Golf Type id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $golfType = $this->GolfTypes->get($id);
        if ($this->GolfTypes->delete($golfType)) {
            $this->Flash->success(__('The golf type has been deleted.'));
        } else {
            $this->Flash->error(__('The golf type could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
