<?php
declare(strict_types=1);

namespace App\Controller\Admin;

use App\Controller\AppController;

/**
 * GolfPlayers Controller
 *
 * @property \App\Model\Table\GolfPlayersTable $GolfPlayers
 */
class GolfPlayersController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $query = $this->GolfPlayers->find()->contain(['Golfs', 'Titles', 'Countries']);
        $golfPlayers = $this->paginate($query);

        $this->set(compact('golfPlayers'));
    }

    /**
     * View method
     *
     * @param string|null $id Golf Player id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $golfPlayer = $this->GolfPlayers->get($id, contain: ['Golfs', 'Titles', 'Countries']);
        $this->set(compact('golfPlayer'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $golfPlayer = $this->GolfPlayers->newEmptyEntity();
        if ($this->request->is('post')) {
            $golfPlayer = $this->GolfPlayers->patchEntity($golfPlayer, $this->request->getData());
            if ($this->GolfPlayers->save($golfPlayer)) {
                $this->Flash->success(__('The golf player has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The golf player could not be saved. Please, try again.'));
        }
        $golfs = $this->GolfPlayers->Golfs->find('list', limit: 200)->all();
        $titles = $this->GolfPlayers->Titles->find('list', limit: 200)->all();
        $countries = $this->GolfPlayers->Countries->find('list', limit: 200)->all();
        $this->set(compact('golfPlayer', 'golfs', 'titles', 'countries'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Golf Player id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $golfPlayer = $this->GolfPlayers->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $golfPlayer = $this->GolfPlayers->patchEntity($golfPlayer, $this->request->getData());
            if ($this->GolfPlayers->save($golfPlayer)) {
                $this->Flash->success(__('The golf player has been saved.'));

                return $this->redirect(['controller' => 'golfs', 'action' => 'view', $golfPlayer->golf_id]);
            }
            $this->Flash->error(__('The golf player could not be saved. Please, try again.'));
        }
        $golfs = $this->GolfPlayers->Golfs->find('list', limit: 200)->all();
        $titles = $this->GolfPlayers->Titles->find('list', limit: 200)->all();
        $countries = $this->GolfPlayers->Countries->find('list', limit: 200)->all();
        $this->set(compact('golfPlayer', 'golfs', 'titles', 'countries'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Golf Player id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $golfPlayer = $this->GolfPlayers->get($id);
        if ($this->GolfPlayers->delete($golfPlayer)) {
            $this->Flash->success(__('The golf player has been deleted.'));
        } else {
            $this->Flash->error(__('The golf player could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
