<?php
declare(strict_types=1);

namespace App\Controller\Admin;

use App\Controller\AppController;

/**
 * CarSettings Controller
 *
 * @property \App\Model\Table\CarSettingsTable $CarSettings
 */
class CarSettingsController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $query = $this->CarSettings->find()->first();
        if ($query) {
            $this->redirect(['action' => 'edit', $query->id]);
        } else {
            $this->redirect(['action' => 'add']);
        }
    }

    /**
     * View method
     *
     * @param string|null $id Car Setting id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $carSetting = $this->CarSettings->get($id, contain: []);
        $this->set(compact('carSetting'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $carSetting = $this->CarSettings->newEmptyEntity();
        if ($this->request->is('post')) {
            $carSetting = $this->CarSettings->patchEntity($carSetting, $this->request->getData());
            if ($this->CarSettings->save($carSetting)) {
                $attachment = $this->request->getData('upload');
                if ($attachment->getError() === 0) {
                    $filename = $attachment->getClientFilename();
                    $extension = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
                    $attachment->moveTo(WWW_ROOT . 'img' . DS . 'cars' . DS . 'logo.' . $extension);
                    $carSetting->event_logo = "logo.{$extension}";
                    $this->CarSettings->save($carSetting);
                }

                $this->Flash->success(__('The car setting has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The car setting could not be saved. Please, try again.'));
        }
        $this->set(compact('carSetting'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Car Setting id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $carSetting = $this->CarSettings->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $carSetting = $this->CarSettings->patchEntity($carSetting, $this->request->getData());
            if ($this->CarSettings->save($carSetting)) {
                $attachment = $this->request->getData('upload');
                if ($attachment->getError() === 0) {
                    $filename = $attachment->getClientFilename();
                    $extension = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
                    $attachment->moveTo(WWW_ROOT . 'img' . DS . 'cars' . DS . 'logo.' . $extension);
                    $carSetting->event_logo = "logo.{$extension}";
                    $this->CarSettings->save($carSetting);
                }
                $this->Flash->success(__('The car setting has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The car setting could not be saved. Please, try again.'));
        }
        $this->set(compact('carSetting'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Car Setting id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $carSetting = $this->CarSettings->get($id);
        if ($this->CarSettings->delete($carSetting)) {
            $this->Flash->success(__('The car setting has been deleted.'));
        } else {
            $this->Flash->error(__('The car setting could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
