<?php
declare(strict_types=1);

namespace App\Controller\Admin;

use App\Controller\AppController;

/**
 * CarParts Controller
 *
 * @property \App\Model\Table\CarPartsTable $CarParts
 */
class CarPartsController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $query = $this->CarParts->find()->contain(['Cars', 'Titles', 'Countries']);
        $carParts = $this->paginate($query);

        $this->set(compact('carParts'));
    }

    /**
     * View method
     *
     * @param string|null $id Car Part id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $carPart = $this->CarParts->get($id, contain: ['Cars', 'Titles', 'Countries']);
        $this->set(compact('carPart'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $carPart = $this->CarParts->newEmptyEntity();
        if ($this->request->is('post')) {
            $carPart = $this->CarParts->patchEntity($carPart, $this->request->getData());
            if ($this->CarParts->save($carPart)) {
                $this->Flash->success(__('The car part has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The car part could not be saved. Please, try again.'));
        }
        $cars = $this->CarParts->Cars->find('list', limit: 200)->all();
        $titles = $this->CarParts->Titles->find('list', limit: 200)->all();
        $countries = $this->CarParts->Countries->find('list', limit: 200)->all();
        $this->set(compact('carPart', 'cars', 'titles', 'countries'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Car Part id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $carPart = $this->CarParts->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $carPart = $this->CarParts->patchEntity($carPart, $this->request->getData());
            if ($this->CarParts->save($carPart)) {
                $this->Flash->success(__('The car part has been saved.'));

                return $this->redirect(['controller' => 'cars', 'action' => 'edit', $carPart->car_id]);
            }
            $this->Flash->error(__('The car part could not be saved. Please, try again.'));
        }
        $cars = $this->CarParts->Cars->find('list', limit: 200)->all();
        $titles = $this->CarParts->Titles->find('list', limit: 200)->all();
        $countries = $this->CarParts->Countries->find('list', limit: 200)->all();
        $this->set(compact('carPart', 'cars', 'titles', 'countries'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Car Part id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $carPart = $this->CarParts->get($id);
        if ($this->CarParts->delete($carPart)) {
            $this->Flash->success(__('The car part has been deleted.'));
        } else {
            $this->Flash->error(__('The car part could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
